@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Double
import kotlin.Suppress

/**
 * Security settings.
 * @property serverSecurityCostPerServerPerYear Physical servers per administrator.
 * @property sqlServerSecurityCostPerServerPerYear Virtual machines per administrator.
 */
public data class SecuritySettingsResponse(
    public val serverSecurityCostPerServerPerYear: Double,
    public val sqlServerSecurityCostPerServerPerYear: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.SecuritySettingsResponse):
            SecuritySettingsResponse = SecuritySettingsResponse(
            serverSecurityCostPerServerPerYear = javaType.serverSecurityCostPerServerPerYear(),
            sqlServerSecurityCostPerServerPerYear = javaType.sqlServerSecurityCostPerServerPerYear(),
        )
    }
}
