@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Suppress

/**
 * Business case settings.
 * @property azureSettings Azure settings for a business case.
 * @property onPremiseSettings On-premise settings.
 */
public data class SettingsResponse(
    public val azureSettings: AzureSettingsResponse,
    public val onPremiseSettings: OnPremiseSettingsResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.SettingsResponse):
            SettingsResponse = SettingsResponse(
            azureSettings = javaType.azureSettings().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.AzureSettingsResponse.Companion.toKotlin(args0)
            }),
            onPremiseSettings = javaType.onPremiseSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.OnPremiseSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
