@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Defines the virtual network resource settings.
 * @property addressSpace Gets or sets the address prefixes for the virtual network.
 * @property dnsServers Gets or sets DHCPOptions that contains an array of DNS servers available to VMs
 * deployed in the virtual network.
 * @property enableDdosProtection Gets or sets a value indicating whether gets or sets whether the
 * DDOS protection should be switched on.
 * @property resourceType The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
 * Expected value is 'Microsoft.Network/virtualNetworks'.
 * @property subnets Gets or sets List of subnets in a VirtualNetwork.
 * @property tags Gets or sets the Resource tags.
 * @property targetResourceGroupName Gets or sets the target resource group name.
 * @property targetResourceName Gets or sets the target Resource name.
 */
public data class VirtualNetworkResourceSettingsResponse(
    public val addressSpace: List<String>? = null,
    public val dnsServers: List<String>? = null,
    public val enableDdosProtection: Boolean? = null,
    public val resourceType: String,
    public val subnets: List<SubnetResourceSettingsResponse>? = null,
    public val tags: Map<String, String>? = null,
    public val targetResourceGroupName: String? = null,
    public val targetResourceName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.VirtualNetworkResourceSettingsResponse):
            VirtualNetworkResourceSettingsResponse = VirtualNetworkResourceSettingsResponse(
            addressSpace = javaType.addressSpace().map({ args0 -> args0 }),
            dnsServers = javaType.dnsServers().map({ args0 -> args0 }),
            enableDdosProtection = javaType.enableDdosProtection().map({ args0 -> args0 }).orElse(null),
            resourceType = javaType.resourceType(),
            subnets = javaType.subnets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.SubnetResourceSettingsResponse.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetResourceGroupName = javaType.targetResourceGroupName().map({ args0 -> args0 }).orElse(null),
            targetResourceName = javaType.targetResourceName(),
        )
    }
}
