@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Class for web application configurations.
 * @property filePath Gets or sets the configuration file path.
 * @property id Gets the ID.
 * @property identifier Gets or sets the identifier for the configuration.
 * @property isDeploymentTimeEditable Gets or sets a value indicating whether the configuration is edited or not by the user.
 * @property localFilePath Gets or sets the configuration local file path.
 * @property name Gets or sets the configuration name.
 * @property secretStoreDetails
 * @property section Gets or sets the configuration section in the file.
 * @property targetFilePath Gets or sets the configuration target file path.
 * @property type Gets or sets the configuration type.
 * @property value Gets or sets the configuration value.
 */
public data class WebApplicationConfigurationResponse(
    public val filePath: String? = null,
    public val id: String,
    public val identifier: String? = null,
    public val isDeploymentTimeEditable: Boolean? = null,
    public val localFilePath: String? = null,
    public val name: String? = null,
    public val secretStoreDetails: SecretStoreDetailsResponse? = null,
    public val section: String? = null,
    public val targetFilePath: String? = null,
    public val type: String? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.WebApplicationConfigurationResponse):
            WebApplicationConfigurationResponse = WebApplicationConfigurationResponse(
            filePath = javaType.filePath().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            identifier = javaType.identifier().map({ args0 -> args0 }).orElse(null),
            isDeploymentTimeEditable = javaType.isDeploymentTimeEditable().map({ args0 -> args0 }).orElse(null),
            localFilePath = javaType.localFilePath().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            secretStoreDetails = javaType.secretStoreDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.SecretStoreDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            section = javaType.section().map({ args0 -> args0 }).orElse(null),
            targetFilePath = javaType.targetFilePath().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
