@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mixedreality.kotlin.inputs

import com.pulumi.azurenative.mixedreality.inputs.ListRemoteRenderingAccountKeysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName Name of an Mixed Reality Account.
 * @property resourceGroupName Name of an Azure resource group.
 */
public data class ListRemoteRenderingAccountKeysPlainArgs(
    public val accountName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.mixedreality.inputs.ListRemoteRenderingAccountKeysPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.mixedreality.inputs.ListRemoteRenderingAccountKeysPlainArgs =
        com.pulumi.azurenative.mixedreality.inputs.ListRemoteRenderingAccountKeysPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListRemoteRenderingAccountKeysPlainArgs].
 */
@PulumiTagMarker
public class ListRemoteRenderingAccountKeysPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of an Mixed Reality Account.
     */
    @JvmName("spbnuhvlxseugbyc")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value Name of an Azure resource group.
     */
    @JvmName("dbtpvvcnmkhsxmex")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListRemoteRenderingAccountKeysPlainArgs =
        ListRemoteRenderingAccountKeysPlainArgs(
            accountName = accountName ?: throw PulumiNullFieldException("accountName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
