@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin

import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.PlmnIdResponse
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.PlmnIdResponse.Companion.toKotlin as plmnIdResponseToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [MobileNetwork].
 */
@PulumiTagMarker
public class MobileNetworkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MobileNetworkArgs = MobileNetworkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MobileNetworkArgsBuilder.() -> Unit) {
        val builder = MobileNetworkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MobileNetwork {
        val builtJavaResource =
            com.pulumi.azurenative.mobilenetwork.MobileNetwork(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MobileNetwork(builtJavaResource)
    }
}

/**
 * Mobile network resource.
 * Azure REST API version: 2023-06-01. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * Other available API versions: 2022-04-01-preview, 2022-11-01, 2023-09-01, 2024-02-01.
 * ## Example Usage
 * ### Create mobile network
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mobileNetwork = new AzureNative.MobileNetwork.MobileNetwork("mobileNetwork", new()
 *     {
 *         Location = "eastus",
 *         MobileNetworkName = "testMobileNetwork",
 *         PublicLandMobileNetworkIdentifier = new AzureNative.MobileNetwork.Inputs.PlmnIdArgs
 *         {
 *             Mcc = "001",
 *             Mnc = "01",
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilenetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilenetwork.NewMobileNetwork(ctx, "mobileNetwork", &mobilenetwork.MobileNetworkArgs{
 * 			Location:          pulumi.String("eastus"),
 * 			MobileNetworkName: pulumi.String("testMobileNetwork"),
 * 			PublicLandMobileNetworkIdentifier: &mobilenetwork.PlmnIdArgs{
 * 				Mcc: pulumi.String("001"),
 * 				Mnc: pulumi.String("01"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilenetwork.MobileNetwork;
 * import com.pulumi.azurenative.mobilenetwork.MobileNetworkArgs;
 * import com.pulumi.azurenative.mobilenetwork.inputs.PlmnIdArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mobileNetwork = new MobileNetwork("mobileNetwork", MobileNetworkArgs.builder()
 *             .location("eastus")
 *             .mobileNetworkName("testMobileNetwork")
 *             .publicLandMobileNetworkIdentifier(PlmnIdArgs.builder()
 *                 .mcc("001")
 *                 .mnc("01")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilenetwork:MobileNetwork testMobileNetwork /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/mobileNetworks/{mobileNetworkName}
 * ```
 */
public class MobileNetwork internal constructor(
    override val javaResource: com.pulumi.azurenative.mobilenetwork.MobileNetwork,
) : KotlinCustomResource(javaResource, MobileNetworkMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the mobile network resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The unique public land mobile network identifier for the network. This is made up of the mobile country code and mobile network code, as defined in https://www.itu.int/rec/T-REC-E.212. The values 001-01 and 001-001 can be used for testing and the values 999-99 and 999-999 can be used on internal private networks.
     */
    public val publicLandMobileNetworkIdentifier: Output<PlmnIdResponse>
        get() = javaResource.publicLandMobileNetworkIdentifier().applyValue({ args0 ->
            args0.let({ args0 -> plmnIdResponseToKotlin(args0) })
        })

    /**
     * The mobile network resource identifier
     */
    public val serviceKey: Output<String>
        get() = javaResource.serviceKey().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MobileNetworkMapper : ResourceMapper<MobileNetwork> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.mobilenetwork.MobileNetwork::class == javaResource::class

    override fun map(javaResource: Resource): MobileNetwork = MobileNetwork(
        javaResource as
            com.pulumi.azurenative.mobilenetwork.MobileNetwork,
    )
}

/**
 * @see [MobileNetwork].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MobileNetwork].
 */
public suspend fun mobileNetwork(
    name: String,
    block: suspend MobileNetworkResourceBuilder.() -> Unit,
): MobileNetwork {
    val builder = MobileNetworkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MobileNetwork].
 * @param name The _unique_ name of the resulting resource.
 */
public fun mobileNetwork(name: String): MobileNetwork {
    val builder = MobileNetworkResourceBuilder()
    builder.name(name)
    return builder.build()
}
