@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin

import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.DiagnosticsUploadConfigurationResponse
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.InstallationResponse
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.InterfacePropertiesResponse
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.LocalDiagnosticsAccessConfigurationResponse
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.PlatformConfigurationResponse
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SiteResourceIdResponse
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.DiagnosticsUploadConfigurationResponse.Companion.toKotlin as diagnosticsUploadConfigurationResponseToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.InstallationResponse.Companion.toKotlin as installationResponseToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.InterfacePropertiesResponse.Companion.toKotlin as interfacePropertiesResponseToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.LocalDiagnosticsAccessConfigurationResponse.Companion.toKotlin as localDiagnosticsAccessConfigurationResponseToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.PlatformConfigurationResponse.Companion.toKotlin as platformConfigurationResponseToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SiteResourceIdResponse.Companion.toKotlin as siteResourceIdResponseToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [PacketCoreControlPlane].
 */
@PulumiTagMarker
public class PacketCoreControlPlaneResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PacketCoreControlPlaneArgs = PacketCoreControlPlaneArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PacketCoreControlPlaneArgsBuilder.() -> Unit) {
        val builder = PacketCoreControlPlaneArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PacketCoreControlPlane {
        val builtJavaResource =
            com.pulumi.azurenative.mobilenetwork.PacketCoreControlPlane(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PacketCoreControlPlane(builtJavaResource)
    }
}

/**
 * Packet core control plane resource.
 * Azure REST API version: 2023-06-01. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * Other available API versions: 2022-03-01-preview, 2022-04-01-preview, 2022-11-01, 2023-09-01, 2024-02-01.
 * ## Example Usage
 * ### Create packet core control plane
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var packetCoreControlPlane = new AzureNative.MobileNetwork.PacketCoreControlPlane("packetCoreControlPlane", new()
 *     {
 *         ControlPlaneAccessInterface = new AzureNative.MobileNetwork.Inputs.InterfacePropertiesArgs
 *         {
 *             Name = "N2",
 *         },
 *         CoreNetworkTechnology = AzureNative.MobileNetwork.CoreNetworkType.CoreNetworkType_5GC,
 *         Installation = new AzureNative.MobileNetwork.Inputs.InstallationArgs
 *         {
 *             DesiredState = AzureNative.MobileNetwork.DesiredInstallationState.Installed,
 *         },
 *         LocalDiagnosticsAccess = new AzureNative.MobileNetwork.Inputs.LocalDiagnosticsAccessConfigurationArgs
 *         {
 *             AuthenticationType = AzureNative.MobileNetwork.AuthenticationType.AAD,
 *             HttpsServerCertificate = new AzureNative.MobileNetwork.Inputs.HttpsServerCertificateArgs
 *             {
 *                 CertificateUrl = "https://contosovault.vault.azure.net/certificates/ingress",
 *             },
 *         },
 *         Location = "eastus",
 *         PacketCoreControlPlaneName = "TestPacketCoreCP",
 *         Platform = new AzureNative.MobileNetwork.Inputs.PlatformConfigurationArgs
 *         {
 *             AzureStackEdgeDevice = new AzureNative.MobileNetwork.Inputs.AzureStackEdgeDeviceResourceIdArgs
 *             {
 *                 Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/TestAzureStackEdgeDevice",
 *             },
 *             ConnectedCluster = new AzureNative.MobileNetwork.Inputs.ConnectedClusterResourceIdArgs
 *             {
 *                 Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Kubernetes/connectedClusters/TestConnectedCluster",
 *             },
 *             CustomLocation = new AzureNative.MobileNetwork.Inputs.CustomLocationResourceIdArgs
 *             {
 *                 Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ExtendedLocation/customLocations/TestCustomLocation",
 *             },
 *             Type = AzureNative.MobileNetwork.PlatformType.AKS_HCI,
 *         },
 *         ResourceGroupName = "rg1",
 *         Sites = new[]
 *         {
 *             new AzureNative.MobileNetwork.Inputs.SiteResourceIdArgs
 *             {
 *                 Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/sites/testSite",
 *             },
 *         },
 *         Sku = AzureNative.MobileNetwork.BillingSku.G0,
 *         UeMtu = 1600,
 *         Version = "0.2.0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilenetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilenetwork.NewPacketCoreControlPlane(ctx, "packetCoreControlPlane", &mobilenetwork.PacketCoreControlPlaneArgs{
 * 			ControlPlaneAccessInterface: &mobilenetwork.InterfacePropertiesArgs{
 * 				Name: pulumi.String("N2"),
 * 			},
 * 			CoreNetworkTechnology: pulumi.String(mobilenetwork.CoreNetworkType_5GC),
 * 			Installation: &mobilenetwork.InstallationArgs{
 * 				DesiredState: pulumi.String(mobilenetwork.DesiredInstallationStateInstalled),
 * 			},
 * 			LocalDiagnosticsAccess: &mobilenetwork.LocalDiagnosticsAccessConfigurationArgs{
 * 				AuthenticationType: pulumi.String(mobilenetwork.AuthenticationTypeAAD),
 * 				HttpsServerCertificate: &mobilenetwork.HttpsServerCertificateArgs{
 * 					CertificateUrl: pulumi.String("https://contosovault.vault.azure.net/certificates/ingress"),
 * 				},
 * 			},
 * 			Location:                   pulumi.String("eastus"),
 * 			PacketCoreControlPlaneName: pulumi.String("TestPacketCoreCP"),
 * 			Platform: &mobilenetwork.PlatformConfigurationArgs{
 * 				AzureStackEdgeDevice: &mobilenetwork.AzureStackEdgeDeviceResourceIdArgs{
 * 					Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/TestAzureStackEdgeDevice"),
 * 				},
 * 				ConnectedCluster: &mobilenetwork.ConnectedClusterResourceIdArgs{
 * 					Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Kubernetes/connectedClusters/TestConnectedCluster"),
 * 				},
 * 				CustomLocation: &mobilenetwork.CustomLocationResourceIdArgs{
 * 					Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ExtendedLocation/customLocations/TestCustomLocation"),
 * 				},
 * 				Type: pulumi.String(mobilenetwork.PlatformType_AKS_HCI),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sites: mobilenetwork.SiteResourceIdArray{
 * 				&mobilenetwork.SiteResourceIdArgs{
 * 					Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/sites/testSite"),
 * 				},
 * 			},
 * 			Sku:     pulumi.String(mobilenetwork.BillingSkuG0),
 * 			UeMtu:   pulumi.Int(1600),
 * 			Version: pulumi.String("0.2.0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilenetwork.PacketCoreControlPlane;
 * import com.pulumi.azurenative.mobilenetwork.PacketCoreControlPlaneArgs;
 * import com.pulumi.azurenative.mobilenetwork.inputs.InterfacePropertiesArgs;
 * import com.pulumi.azurenative.mobilenetwork.inputs.InstallationArgs;
 * import com.pulumi.azurenative.mobilenetwork.inputs.LocalDiagnosticsAccessConfigurationArgs;
 * import com.pulumi.azurenative.mobilenetwork.inputs.HttpsServerCertificateArgs;
 * import com.pulumi.azurenative.mobilenetwork.inputs.PlatformConfigurationArgs;
 * import com.pulumi.azurenative.mobilenetwork.inputs.AzureStackEdgeDeviceResourceIdArgs;
 * import com.pulumi.azurenative.mobilenetwork.inputs.ConnectedClusterResourceIdArgs;
 * import com.pulumi.azurenative.mobilenetwork.inputs.CustomLocationResourceIdArgs;
 * import com.pulumi.azurenative.mobilenetwork.inputs.SiteResourceIdArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var packetCoreControlPlane = new PacketCoreControlPlane("packetCoreControlPlane", PacketCoreControlPlaneArgs.builder()
 *             .controlPlaneAccessInterface(InterfacePropertiesArgs.builder()
 *                 .name("N2")
 *                 .build())
 *             .coreNetworkTechnology("5GC")
 *             .installation(InstallationArgs.builder()
 *                 .desiredState("Installed")
 *                 .build())
 *             .localDiagnosticsAccess(LocalDiagnosticsAccessConfigurationArgs.builder()
 *                 .authenticationType("AAD")
 *                 .httpsServerCertificate(HttpsServerCertificateArgs.builder()
 *                     .certificateUrl("https://contosovault.vault.azure.net/certificates/ingress")
 *                     .build())
 *                 .build())
 *             .location("eastus")
 *             .packetCoreControlPlaneName("TestPacketCoreCP")
 *             .platform(PlatformConfigurationArgs.builder()
 *                 .azureStackEdgeDevice(AzureStackEdgeDeviceResourceIdArgs.builder()
 *                     .id("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/TestAzureStackEdgeDevice")
 *                     .build())
 *                 .connectedCluster(ConnectedClusterResourceIdArgs.builder()
 *                     .id("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Kubernetes/connectedClusters/TestConnectedCluster")
 *                     .build())
 *                 .customLocation(CustomLocationResourceIdArgs.builder()
 *                     .id("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ExtendedLocation/customLocations/TestCustomLocation")
 *                     .build())
 *                 .type("AKS-HCI")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .sites(SiteResourceIdArgs.builder()
 *                 .id("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/sites/testSite")
 *                 .build())
 *             .sku("G0")
 *             .ueMtu(1600)
 *             .version("0.2.0")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilenetwork:PacketCoreControlPlane TestPacketCoreCP /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}
 * ```
 */
public class PacketCoreControlPlane internal constructor(
    override val javaResource: com.pulumi.azurenative.mobilenetwork.PacketCoreControlPlane,
) : KotlinCustomResource(javaResource, PacketCoreControlPlaneMapper) {
    /**
     * The control plane interface on the access network. For 5G networks, this is the N2 interface. For 4G networks, this is the S1-MME interface.
     */
    public val controlPlaneAccessInterface: Output<InterfacePropertiesResponse>
        get() = javaResource.controlPlaneAccessInterface().applyValue({ args0 ->
            args0.let({ args0 ->
                interfacePropertiesResponseToKotlin(args0)
            })
        })

    /**
     * The core network technology generation (5G core or EPC / 4G core).
     */
    public val coreNetworkTechnology: Output<String>?
        get() = javaResource.coreNetworkTechnology().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration for uploading packet core diagnostics
     */
    public val diagnosticsUpload: Output<DiagnosticsUploadConfigurationResponse>?
        get() = javaResource.diagnosticsUpload().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> diagnosticsUploadConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The identity used to retrieve the ingress certificate from Azure key vault.
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The installation state of the packet core control plane resource.
     */
    public val installation: Output<InstallationResponse>?
        get() = javaResource.installation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    installationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The currently installed version of the packet core software.
     */
    public val installedVersion: Output<String>
        get() = javaResource.installedVersion().applyValue({ args0 -> args0 })

    /**
     * Settings to allow interoperability with third party components e.g. RANs and UEs.
     */
    public val interopSettings: Output<Any>?
        get() = javaResource.interopSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The kubernetes ingress configuration to control access to packet core diagnostics over local APIs.
     */
    public val localDiagnosticsAccess: Output<LocalDiagnosticsAccessConfigurationResponse>
        get() = javaResource.localDiagnosticsAccess().applyValue({ args0 ->
            args0.let({ args0 ->
                localDiagnosticsAccessConfigurationResponseToKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The platform where the packet core is deployed.
     */
    public val platform: Output<PlatformConfigurationResponse>
        get() = javaResource.platform().applyValue({ args0 ->
            args0.let({ args0 ->
                platformConfigurationResponseToKotlin(args0)
            })
        })

    /**
     * The provisioning state of the packet core control plane resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The previous version of the packet core software that was deployed. Used when performing the rollback action.
     */
    public val rollbackVersion: Output<String>
        get() = javaResource.rollbackVersion().applyValue({ args0 -> args0 })

    /**
     * Site(s) under which this packet core control plane should be deployed. The sites must be in the same location as the packet core control plane.
     */
    public val sites: Output<List<SiteResourceIdResponse>>
        get() = javaResource.sites().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    siteResourceIdResponseToKotlin(args0)
                })
            })
        })

    /**
     * The SKU defining the throughput and SIM allowances for this packet core control plane deployment.
     */
    public val sku: Output<String>
        get() = javaResource.sku().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The MTU (in bytes) signaled to the UE. The same MTU is set on the user plane data links for all data networks. The MTU set on the user plane access link is calculated to be 60 bytes greater than this value to allow for GTP encapsulation.
     */
    public val ueMtu: Output<Int>?
        get() = javaResource.ueMtu().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The desired version of the packet core software.
     */
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object PacketCoreControlPlaneMapper : ResourceMapper<PacketCoreControlPlane> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.mobilenetwork.PacketCoreControlPlane::class == javaResource::class

    override fun map(javaResource: Resource): PacketCoreControlPlane =
        PacketCoreControlPlane(
            javaResource as
                com.pulumi.azurenative.mobilenetwork.PacketCoreControlPlane,
        )
}

/**
 * @see [PacketCoreControlPlane].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PacketCoreControlPlane].
 */
public suspend fun packetCoreControlPlane(
    name: String,
    block: suspend PacketCoreControlPlaneResourceBuilder.() -> Unit,
): PacketCoreControlPlane {
    val builder = PacketCoreControlPlaneResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PacketCoreControlPlane].
 * @param name The _unique_ name of the resulting resource.
 */
public fun packetCoreControlPlane(name: String): PacketCoreControlPlane {
    val builder = PacketCoreControlPlaneResourceBuilder()
    builder.name(name)
    return builder.build()
}
