@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin

import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.InterfacePropertiesResponse
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.InterfacePropertiesResponse.Companion.toKotlin as interfacePropertiesResponseToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [PacketCoreDataPlane].
 */
@PulumiTagMarker
public class PacketCoreDataPlaneResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PacketCoreDataPlaneArgs = PacketCoreDataPlaneArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PacketCoreDataPlaneArgsBuilder.() -> Unit) {
        val builder = PacketCoreDataPlaneArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PacketCoreDataPlane {
        val builtJavaResource =
            com.pulumi.azurenative.mobilenetwork.PacketCoreDataPlane(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PacketCoreDataPlane(builtJavaResource)
    }
}

/**
 * Packet core data plane resource. Must be created in the same location as its parent packet core control plane.
 * Azure REST API version: 2023-06-01. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * Other available API versions: 2022-04-01-preview, 2022-11-01, 2023-09-01, 2024-02-01.
 * ## Example Usage
 * ### Create packet core data plane
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var packetCoreDataPlane = new AzureNative.MobileNetwork.PacketCoreDataPlane("packetCoreDataPlane", new()
 *     {
 *         Location = "eastus",
 *         PacketCoreControlPlaneName = "testPacketCoreCP",
 *         PacketCoreDataPlaneName = "testPacketCoreDP",
 *         ResourceGroupName = "rg1",
 *         UserPlaneAccessInterface = new AzureNative.MobileNetwork.Inputs.InterfacePropertiesArgs
 *         {
 *             Name = "N3",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilenetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilenetwork.NewPacketCoreDataPlane(ctx, "packetCoreDataPlane", &mobilenetwork.PacketCoreDataPlaneArgs{
 * 			Location:                   pulumi.String("eastus"),
 * 			PacketCoreControlPlaneName: pulumi.String("testPacketCoreCP"),
 * 			PacketCoreDataPlaneName:    pulumi.String("testPacketCoreDP"),
 * 			ResourceGroupName:          pulumi.String("rg1"),
 * 			UserPlaneAccessInterface: &mobilenetwork.InterfacePropertiesArgs{
 * 				Name: pulumi.String("N3"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilenetwork.PacketCoreDataPlane;
 * import com.pulumi.azurenative.mobilenetwork.PacketCoreDataPlaneArgs;
 * import com.pulumi.azurenative.mobilenetwork.inputs.InterfacePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var packetCoreDataPlane = new PacketCoreDataPlane("packetCoreDataPlane", PacketCoreDataPlaneArgs.builder()
 *             .location("eastus")
 *             .packetCoreControlPlaneName("testPacketCoreCP")
 *             .packetCoreDataPlaneName("testPacketCoreDP")
 *             .resourceGroupName("rg1")
 *             .userPlaneAccessInterface(InterfacePropertiesArgs.builder()
 *                 .name("N3")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilenetwork:PacketCoreDataPlane TestPacketCoreDP /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/packetCoreDataPlanes/{packetCoreDataPlaneName}
 * ```
 */
public class PacketCoreDataPlane internal constructor(
    override val javaResource: com.pulumi.azurenative.mobilenetwork.PacketCoreDataPlane,
) : KotlinCustomResource(javaResource, PacketCoreDataPlaneMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the packet core data plane resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The user plane interface on the access network. For 5G networks, this is the N3 interface. For 4G networks, this is the S1-U interface.
     */
    public val userPlaneAccessInterface: Output<InterfacePropertiesResponse>
        get() = javaResource.userPlaneAccessInterface().applyValue({ args0 ->
            args0.let({ args0 ->
                interfacePropertiesResponseToKotlin(args0)
            })
        })
}

public object PacketCoreDataPlaneMapper : ResourceMapper<PacketCoreDataPlane> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.mobilenetwork.PacketCoreDataPlane::class == javaResource::class

    override fun map(javaResource: Resource): PacketCoreDataPlane = PacketCoreDataPlane(
        javaResource
            as com.pulumi.azurenative.mobilenetwork.PacketCoreDataPlane,
    )
}

/**
 * @see [PacketCoreDataPlane].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PacketCoreDataPlane].
 */
public suspend fun packetCoreDataPlane(
    name: String,
    block: suspend PacketCoreDataPlaneResourceBuilder.() -> Unit,
): PacketCoreDataPlane {
    val builder = PacketCoreDataPlaneResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PacketCoreDataPlane].
 * @param name The _unique_ name of the resulting resource.
 */
public fun packetCoreDataPlane(name: String): PacketCoreDataPlane {
    val builder = PacketCoreDataPlaneResourceBuilder()
    builder.name(name)
    return builder.build()
}
