@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin

import com.pulumi.azurenative.mobilenetwork.PacketCoreDataPlaneArgs.builder
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.InterfacePropertiesArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.InterfacePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Packet core data plane resource. Must be created in the same location as its parent packet core control plane.
 * Azure REST API version: 2023-06-01. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * Other available API versions: 2022-04-01-preview, 2022-11-01, 2023-09-01, 2024-02-01.
 * ## Example Usage
 * ### Create packet core data plane
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var packetCoreDataPlane = new AzureNative.MobileNetwork.PacketCoreDataPlane("packetCoreDataPlane", new()
 *     {
 *         Location = "eastus",
 *         PacketCoreControlPlaneName = "testPacketCoreCP",
 *         PacketCoreDataPlaneName = "testPacketCoreDP",
 *         ResourceGroupName = "rg1",
 *         UserPlaneAccessInterface = new AzureNative.MobileNetwork.Inputs.InterfacePropertiesArgs
 *         {
 *             Name = "N3",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilenetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilenetwork.NewPacketCoreDataPlane(ctx, "packetCoreDataPlane", &mobilenetwork.PacketCoreDataPlaneArgs{
 * 			Location:                   pulumi.String("eastus"),
 * 			PacketCoreControlPlaneName: pulumi.String("testPacketCoreCP"),
 * 			PacketCoreDataPlaneName:    pulumi.String("testPacketCoreDP"),
 * 			ResourceGroupName:          pulumi.String("rg1"),
 * 			UserPlaneAccessInterface: &mobilenetwork.InterfacePropertiesArgs{
 * 				Name: pulumi.String("N3"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilenetwork.PacketCoreDataPlane;
 * import com.pulumi.azurenative.mobilenetwork.PacketCoreDataPlaneArgs;
 * import com.pulumi.azurenative.mobilenetwork.inputs.InterfacePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var packetCoreDataPlane = new PacketCoreDataPlane("packetCoreDataPlane", PacketCoreDataPlaneArgs.builder()
 *             .location("eastus")
 *             .packetCoreControlPlaneName("testPacketCoreCP")
 *             .packetCoreDataPlaneName("testPacketCoreDP")
 *             .resourceGroupName("rg1")
 *             .userPlaneAccessInterface(InterfacePropertiesArgs.builder()
 *                 .name("N3")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilenetwork:PacketCoreDataPlane TestPacketCoreDP /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/{packetCoreControlPlaneName}/packetCoreDataPlanes/{packetCoreDataPlaneName}
 * ```
 * @property location The geo-location where the resource lives
 * @property packetCoreControlPlaneName The name of the packet core control plane.
 * @property packetCoreDataPlaneName The name of the packet core data plane.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property userPlaneAccessInterface The user plane interface on the access network. For 5G networks, this is the N3 interface. For 4G networks, this is the S1-U interface.
 */
public data class PacketCoreDataPlaneArgs(
    public val location: Output<String>? = null,
    public val packetCoreControlPlaneName: Output<String>? = null,
    public val packetCoreDataPlaneName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userPlaneAccessInterface: Output<InterfacePropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.PacketCoreDataPlaneArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.PacketCoreDataPlaneArgs =
        com.pulumi.azurenative.mobilenetwork.PacketCoreDataPlaneArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .packetCoreControlPlaneName(packetCoreControlPlaneName?.applyValue({ args0 -> args0 }))
            .packetCoreDataPlaneName(packetCoreDataPlaneName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userPlaneAccessInterface(
                userPlaneAccessInterface?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [PacketCoreDataPlaneArgs].
 */
@PulumiTagMarker
public class PacketCoreDataPlaneArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var packetCoreControlPlaneName: Output<String>? = null

    private var packetCoreDataPlaneName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userPlaneAccessInterface: Output<InterfacePropertiesArgs>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("qhncirablanfrrcc")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the packet core control plane.
     */
    @JvmName("kwgvpydcqpkkcqvw")
    public suspend fun packetCoreControlPlaneName(`value`: Output<String>) {
        this.packetCoreControlPlaneName = value
    }

    /**
     * @param value The name of the packet core data plane.
     */
    @JvmName("qoctasrfhfqpnnnx")
    public suspend fun packetCoreDataPlaneName(`value`: Output<String>) {
        this.packetCoreDataPlaneName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("umrgybhbmxiyouwx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("eyiyxfcxdaniyetq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The user plane interface on the access network. For 5G networks, this is the N3 interface. For 4G networks, this is the S1-U interface.
     */
    @JvmName("nggbbcfntqbpscao")
    public suspend fun userPlaneAccessInterface(`value`: Output<InterfacePropertiesArgs>) {
        this.userPlaneAccessInterface = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("evpchtnvslrietwi")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the packet core control plane.
     */
    @JvmName("jtvpigfuqqrrdjju")
    public suspend fun packetCoreControlPlaneName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packetCoreControlPlaneName = mapped
    }

    /**
     * @param value The name of the packet core data plane.
     */
    @JvmName("aculiqmesgwbtbnc")
    public suspend fun packetCoreDataPlaneName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packetCoreDataPlaneName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vuusjshopendexcj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("acdtrirpwutdvniv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("eitgxlbvxihgwxjb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The user plane interface on the access network. For 5G networks, this is the N3 interface. For 4G networks, this is the S1-U interface.
     */
    @JvmName("sxechuykhuydyohk")
    public suspend fun userPlaneAccessInterface(`value`: InterfacePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userPlaneAccessInterface = mapped
    }

    /**
     * @param argument The user plane interface on the access network. For 5G networks, this is the N3 interface. For 4G networks, this is the S1-U interface.
     */
    @JvmName("qnhyhtgwmxobgcgw")
    public suspend
    fun userPlaneAccessInterface(argument: suspend InterfacePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = InterfacePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.userPlaneAccessInterface = mapped
    }

    internal fun build(): PacketCoreDataPlaneArgs = PacketCoreDataPlaneArgs(
        location = location,
        packetCoreControlPlaneName = packetCoreControlPlaneName,
        packetCoreDataPlaneName = packetCoreDataPlaneName,
        resourceGroupName = resourceGroupName,
        tags = tags,
        userPlaneAccessInterface = userPlaneAccessInterface,
    )
}
