@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin

import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.AmbrResponse
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SliceConfigurationResponse
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SliceResourceIdResponse
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.AmbrResponse.Companion.toKotlin as ambrResponseToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SliceConfigurationResponse.Companion.toKotlin as sliceConfigurationResponseToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SliceResourceIdResponse.Companion.toKotlin as sliceResourceIdResponseToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [SimPolicy].
 */
@PulumiTagMarker
public class SimPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SimPolicyArgs = SimPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SimPolicyArgsBuilder.() -> Unit) {
        val builder = SimPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SimPolicy {
        val builtJavaResource = com.pulumi.azurenative.mobilenetwork.SimPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SimPolicy(builtJavaResource)
    }
}

/**
 * SIM policy resource.
 * Azure REST API version: 2023-06-01. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * Other available API versions: 2022-04-01-preview, 2022-11-01, 2023-09-01, 2024-02-01.
 * ## Example Usage
 * ### Create SIM policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var simPolicy = new AzureNative.MobileNetwork.SimPolicy("simPolicy", new()
 *     {
 *         DefaultSlice = new AzureNative.MobileNetwork.Inputs.SliceResourceIdArgs
 *         {
 *             Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/slices/testSlice",
 *         },
 *         Location = "eastus",
 *         MobileNetworkName = "testMobileNetwork",
 *         RegistrationTimer = 3240,
 *         ResourceGroupName = "rg1",
 *         SimPolicyName = "testPolicy",
 *         SliceConfigurations = new[]
 *         {
 *             new AzureNative.MobileNetwork.Inputs.SliceConfigurationArgs
 *             {
 *                 DataNetworkConfigurations = new[]
 *                 {
 *                     new AzureNative.MobileNetwork.Inputs.DataNetworkConfigurationArgs
 *                     {
 *                         AdditionalAllowedSessionTypes = new() { },
 *                         AllocationAndRetentionPriorityLevel = 9,
 *                         AllowedServices = new[]
 *                         {
 *                             new AzureNative.MobileNetwork.Inputs.ServiceResourceIdArgs
 *                             {
 *                                 Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/services/testService",
 *                             },
 *                         },
 *                         DataNetwork = new AzureNative.MobileNetwork.Inputs.DataNetworkResourceIdArgs
 *                         {
 *                             Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/dataNetworks/testdataNetwork",
 *                         },
 *                         DefaultSessionType = AzureNative.MobileNetwork.PduSessionType.IPv4,
 *                         FiveQi = 9,
 *                         MaximumNumberOfBufferedPackets = 200,
 *                         PreemptionCapability = AzureNative.MobileNetwork.PreemptionCapability.NotPreempt,
 *                         PreemptionVulnerability = AzureNative.MobileNetwork.PreemptionVulnerability.Preemptable,
 *                         SessionAmbr = new AzureNative.MobileNetwork.Inputs.AmbrArgs
 *                         {
 *                             Downlink = "1 Gbps",
 *                             Uplink = "500 Mbps",
 *                         },
 *                     },
 *                 },
 *                 DefaultDataNetwork = new AzureNative.MobileNetwork.Inputs.DataNetworkResourceIdArgs
 *                 {
 *                     Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/dataNetworks/testdataNetwork",
 *                 },
 *                 Slice = new AzureNative.MobileNetwork.Inputs.SliceResourceIdArgs
 *                 {
 *                     Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/slices/testSlice",
 *                 },
 *             },
 *         },
 *         UeAmbr = new AzureNative.MobileNetwork.Inputs.AmbrArgs
 *         {
 *             Downlink = "1 Gbps",
 *             Uplink = "500 Mbps",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilenetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilenetwork.NewSimPolicy(ctx, "simPolicy", &mobilenetwork.SimPolicyArgs{
 * 			DefaultSlice: &mobilenetwork.SliceResourceIdArgs{
 * 				Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/slices/testSlice"),
 * 			},
 * 			Location:          pulumi.String("eastus"),
 * 			MobileNetworkName: pulumi.String("testMobileNetwork"),
 * 			RegistrationTimer: pulumi.Int(3240),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			SimPolicyName:     pulumi.String("testPolicy"),
 * 			SliceConfigurations: mobilenetwork.SliceConfigurationArray{
 * 				&mobilenetwork.SliceConfigurationArgs{
 * 					DataNetworkConfigurations: mobilenetwork.DataNetworkConfigurationArray{
 * 						&mobilenetwork.DataNetworkConfigurationArgs{
 * 							AdditionalAllowedSessionTypes:       pulumi.StringArray{},
 * 							AllocationAndRetentionPriorityLevel: pulumi.Int(9),
 * 							AllowedServices: mobilenetwork.ServiceResourceIdArray{
 * 								&mobilenetwork.ServiceResourceIdArgs{
 * 									Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/services/testService"),
 * 								},
 * 							},
 * 							DataNetwork: &mobilenetwork.DataNetworkResourceIdArgs{
 * 								Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/dataNetworks/testdataNetwork"),
 * 							},
 * 							DefaultSessionType:             pulumi.String(mobilenetwork.PduSessionTypeIPv4),
 * 							FiveQi:                         pulumi.Int(9),
 * 							MaximumNumberOfBufferedPackets: pulumi.Int(200),
 * 							PreemptionCapability:           pulumi.String(mobilenetwork.PreemptionCapabilityNotPreempt),
 * 							PreemptionVulnerability:        pulumi.String(mobilenetwork.PreemptionVulnerabilityPreemptable),
 * 							SessionAmbr: &mobilenetwork.AmbrArgs{
 * 								Downlink: pulumi.String("1 Gbps"),
 * 								Uplink:   pulumi.String("500 Mbps"),
 * 							},
 * 						},
 * 					},
 * 					DefaultDataNetwork: &mobilenetwork.DataNetworkResourceIdArgs{
 * 						Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/dataNetworks/testdataNetwork"),
 * 					},
 * 					Slice: &mobilenetwork.SliceResourceIdArgs{
 * 						Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/slices/testSlice"),
 * 					},
 * 				},
 * 			},
 * 			UeAmbr: &mobilenetwork.AmbrArgs{
 * 				Downlink: pulumi.String("1 Gbps"),
 * 				Uplink:   pulumi.String("500 Mbps"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilenetwork.SimPolicy;
 * import com.pulumi.azurenative.mobilenetwork.SimPolicyArgs;
 * import com.pulumi.azurenative.mobilenetwork.inputs.SliceResourceIdArgs;
 * import com.pulumi.azurenative.mobilenetwork.inputs.SliceConfigurationArgs;
 * import com.pulumi.azurenative.mobilenetwork.inputs.DataNetworkResourceIdArgs;
 * import com.pulumi.azurenative.mobilenetwork.inputs.AmbrArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var simPolicy = new SimPolicy("simPolicy", SimPolicyArgs.builder()
 *             .defaultSlice(SliceResourceIdArgs.builder()
 *                 .id("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/slices/testSlice")
 *                 .build())
 *             .location("eastus")
 *             .mobileNetworkName("testMobileNetwork")
 *             .registrationTimer(3240)
 *             .resourceGroupName("rg1")
 *             .simPolicyName("testPolicy")
 *             .sliceConfigurations(SliceConfigurationArgs.builder()
 *                 .dataNetworkConfigurations(DataNetworkConfigurationArgs.builder()
 *                     .additionalAllowedSessionTypes()
 *                     .allocationAndRetentionPriorityLevel(9)
 *                     .allowedServices(ServiceResourceIdArgs.builder()
 *                         .id("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/services/testService")
 *                         .build())
 *                     .dataNetwork(DataNetworkResourceIdArgs.builder()
 *                         .id("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/dataNetworks/testdataNetwork")
 *                         .build())
 *                     .defaultSessionType("IPv4")
 *                     .fiveQi(9)
 *                     .maximumNumberOfBufferedPackets(200)
 *                     .preemptionCapability("NotPreempt")
 *                     .preemptionVulnerability("Preemptable")
 *                     .sessionAmbr(AmbrArgs.builder()
 *                         .downlink("1 Gbps")
 *                         .uplink("500 Mbps")
 *                         .build())
 *                     .build())
 *                 .defaultDataNetwork(DataNetworkResourceIdArgs.builder()
 *                     .id("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/dataNetworks/testdataNetwork")
 *                     .build())
 *                 .slice(SliceResourceIdArgs.builder()
 *                     .id("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/slices/testSlice")
 *                     .build())
 *                 .build())
 *             .ueAmbr(AmbrArgs.builder()
 *                 .downlink("1 Gbps")
 *                 .uplink("500 Mbps")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilenetwork:SimPolicy testPolicy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/mobileNetworks/{mobileNetworkName}/simPolicies/{simPolicyName}
 * ```
 */
public class SimPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.mobilenetwork.SimPolicy,
) : KotlinCustomResource(javaResource, SimPolicyMapper) {
    /**
     * The default slice to use if the UE does not explicitly specify it. This slice must exist in the `sliceConfigurations` map. The slice must be in the same location as the SIM policy.
     */
    public val defaultSlice: Output<SliceResourceIdResponse>
        get() = javaResource.defaultSlice().applyValue({ args0 ->
            args0.let({ args0 ->
                sliceResourceIdResponseToKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the SIM policy resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * UE periodic registration update timer (5G) or UE periodic tracking area update timer (4G), in seconds.
     */
    public val registrationTimer: Output<Int>?
        get() = javaResource.registrationTimer().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * RAT/Frequency Selection Priority Index, defined in 3GPP TS 36.413. This is an optional setting and by default is unspecified.
     */
    public val rfspIndex: Output<Int>?
        get() = javaResource.rfspIndex().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A dictionary of sites to the provisioning state of this SIM policy on that site.
     */
    public val siteProvisioningState: Output<Map<String, String>>
        get() = javaResource.siteProvisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The allowed slices and the settings to use for them. The list must not contain duplicate items and must contain at least one item.
     */
    public val sliceConfigurations: Output<List<SliceConfigurationResponse>>
        get() = javaResource.sliceConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> sliceConfigurationResponseToKotlin(args0) })
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Aggregate maximum bit rate across all non-GBR QoS flows of all PDU sessions of a given UE. See 3GPP TS23.501 section 5.7.2.6 for a full description of the UE-AMBR.
     */
    public val ueAmbr: Output<AmbrResponse>
        get() = javaResource.ueAmbr().applyValue({ args0 ->
            args0.let({ args0 ->
                ambrResponseToKotlin(args0)
            })
        })
}

public object SimPolicyMapper : ResourceMapper<SimPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.mobilenetwork.SimPolicy::class == javaResource::class

    override fun map(javaResource: Resource): SimPolicy = SimPolicy(
        javaResource as
            com.pulumi.azurenative.mobilenetwork.SimPolicy,
    )
}

/**
 * @see [SimPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SimPolicy].
 */
public suspend fun simPolicy(name: String, block: suspend SimPolicyResourceBuilder.() -> Unit):
    SimPolicy {
    val builder = SimPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SimPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun simPolicy(name: String): SimPolicy {
    val builder = SimPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
