@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin

import com.pulumi.azurenative.mobilenetwork.SliceArgs.builder
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.SnssaiArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.SnssaiArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Network slice resource. Must be created in the same location as its parent mobile network.
 * Azure REST API version: 2023-06-01. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * Other available API versions: 2022-04-01-preview, 2022-11-01, 2023-09-01, 2024-02-01.
 * ## Example Usage
 * ### Create network slice
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var slice = new AzureNative.MobileNetwork.Slice("slice", new()
 *     {
 *         Description = "myFavouriteSlice",
 *         Location = "eastus",
 *         MobileNetworkName = "testMobileNetwork",
 *         ResourceGroupName = "rg1",
 *         SliceName = "testSlice",
 *         Snssai = new AzureNative.MobileNetwork.Inputs.SnssaiArgs
 *         {
 *             Sd = "1abcde",
 *             Sst = 1,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilenetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilenetwork.NewSlice(ctx, "slice", &mobilenetwork.SliceArgs{
 * 			Description:       pulumi.String("myFavouriteSlice"),
 * 			Location:          pulumi.String("eastus"),
 * 			MobileNetworkName: pulumi.String("testMobileNetwork"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			SliceName:         pulumi.String("testSlice"),
 * 			Snssai: &mobilenetwork.SnssaiArgs{
 * 				Sd:  pulumi.String("1abcde"),
 * 				Sst: pulumi.Int(1),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilenetwork.Slice;
 * import com.pulumi.azurenative.mobilenetwork.SliceArgs;
 * import com.pulumi.azurenative.mobilenetwork.inputs.SnssaiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var slice = new Slice("slice", SliceArgs.builder()
 *             .description("myFavouriteSlice")
 *             .location("eastus")
 *             .mobileNetworkName("testMobileNetwork")
 *             .resourceGroupName("rg1")
 *             .sliceName("testSlice")
 *             .snssai(SnssaiArgs.builder()
 *                 .sd("1abcde")
 *                 .sst(1)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilenetwork:Slice testSlice /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/mobileNetworks/{mobileNetworkName}/slices/{sliceName}
 * ```
 * @property description An optional description for this network slice.
 * @property location The geo-location where the resource lives
 * @property mobileNetworkName The name of the mobile network.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sliceName The name of the network slice.
 * @property snssai Single-network slice selection assistance information (S-NSSAI). Unique at the scope of a mobile network.
 * @property tags Resource tags.
 */
public data class SliceArgs(
    public val description: Output<String>? = null,
    public val location: Output<String>? = null,
    public val mobileNetworkName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sliceName: Output<String>? = null,
    public val snssai: Output<SnssaiArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.SliceArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.SliceArgs =
        com.pulumi.azurenative.mobilenetwork.SliceArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .mobileNetworkName(mobileNetworkName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sliceName(sliceName?.applyValue({ args0 -> args0 }))
            .snssai(snssai?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SliceArgs].
 */
@PulumiTagMarker
public class SliceArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var location: Output<String>? = null

    private var mobileNetworkName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sliceName: Output<String>? = null

    private var snssai: Output<SnssaiArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value An optional description for this network slice.
     */
    @JvmName("aoajtqrpjvqxrbim")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("qkbjsswevgpyhmcq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the mobile network.
     */
    @JvmName("vrypoghwecqvebcu")
    public suspend fun mobileNetworkName(`value`: Output<String>) {
        this.mobileNetworkName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("iaogiqblxejlhdfm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the network slice.
     */
    @JvmName("usmtsuoalxcbyasl")
    public suspend fun sliceName(`value`: Output<String>) {
        this.sliceName = value
    }

    /**
     * @param value Single-network slice selection assistance information (S-NSSAI). Unique at the scope of a mobile network.
     */
    @JvmName("kywvwsffhxijrmnx")
    public suspend fun snssai(`value`: Output<SnssaiArgs>) {
        this.snssai = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("mianxwcidmwvitxf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value An optional description for this network slice.
     */
    @JvmName("hfpwyqhhncbkecjy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("eaptaixugmwtnaag")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the mobile network.
     */
    @JvmName("orxslxjccrcqoefj")
    public suspend fun mobileNetworkName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mobileNetworkName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hormfuruxafotrnv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the network slice.
     */
    @JvmName("ajealobvwhdfndai")
    public suspend fun sliceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sliceName = mapped
    }

    /**
     * @param value Single-network slice selection assistance information (S-NSSAI). Unique at the scope of a mobile network.
     */
    @JvmName("aeyomlltxinohrgi")
    public suspend fun snssai(`value`: SnssaiArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snssai = mapped
    }

    /**
     * @param argument Single-network slice selection assistance information (S-NSSAI). Unique at the scope of a mobile network.
     */
    @JvmName("vxgmsqwrlybeqyju")
    public suspend fun snssai(argument: suspend SnssaiArgsBuilder.() -> Unit) {
        val toBeMapped = SnssaiArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.snssai = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("iqclxmisvufitnqe")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("jspbwletclvvfllu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SliceArgs = SliceArgs(
        description = description,
        location = location,
        mobileNetworkName = mobileNetworkName,
        resourceGroupName = resourceGroupName,
        sliceName = sliceName,
        snssai = snssai,
        tags = tags,
    )
}
