@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.ConnectedClusterResourceIdArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Reference to an Azure Arc custom location resource.
 * @property id Azure Arc connected cluster resource ID.
 */
public data class ConnectedClusterResourceIdArgs(
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.ConnectedClusterResourceIdArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.ConnectedClusterResourceIdArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.ConnectedClusterResourceIdArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectedClusterResourceIdArgs].
 */
@PulumiTagMarker
public class ConnectedClusterResourceIdArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Azure Arc connected cluster resource ID.
     */
    @JvmName("edfftwuhvwgqibiv")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Azure Arc connected cluster resource ID.
     */
    @JvmName("cydaivcyyvmpmtyj")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): ConnectedClusterResourceIdArgs = ConnectedClusterResourceIdArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
