@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.GetSimGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property simGroupName The name of the SIM Group.
 */
public data class GetSimGroupPlainArgs(
    public val resourceGroupName: String,
    public val simGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.GetSimGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.GetSimGroupPlainArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.GetSimGroupPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .simGroupName(simGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSimGroupPlainArgs].
 */
@PulumiTagMarker
public class GetSimGroupPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var simGroupName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dfowehtqqmkladdo")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the SIM Group.
     */
    @JvmName("uffpbleqntjcxcae")
    public suspend fun simGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.simGroupName = mapped
    }

    internal fun build(): GetSimGroupPlainArgs = GetSimGroupPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        simGroupName = simGroupName ?: throw PulumiNullFieldException("simGroupName"),
    )
}
