@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.GetSimPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property mobileNetworkName The name of the mobile network.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property simPolicyName The name of the SIM policy.
 */
public data class GetSimPolicyPlainArgs(
    public val mobileNetworkName: String,
    public val resourceGroupName: String,
    public val simPolicyName: String,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.GetSimPolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.GetSimPolicyPlainArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.GetSimPolicyPlainArgs.builder()
            .mobileNetworkName(mobileNetworkName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .simPolicyName(simPolicyName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSimPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetSimPolicyPlainArgsBuilder internal constructor() {
    private var mobileNetworkName: String? = null

    private var resourceGroupName: String? = null

    private var simPolicyName: String? = null

    /**
     * @param value The name of the mobile network.
     */
    @JvmName("pxubvgqsccwhrgac")
    public suspend fun mobileNetworkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.mobileNetworkName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("egbkorwklndxelbx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the SIM policy.
     */
    @JvmName("qukgupvmkytshvep")
    public suspend fun simPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.simPolicyName = mapped
    }

    internal fun build(): GetSimPolicyPlainArgs = GetSimPolicyPlainArgs(
        mobileNetworkName = mobileNetworkName ?: throw PulumiNullFieldException("mobileNetworkName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        simPolicyName = simPolicyName ?: throw PulumiNullFieldException("simPolicyName"),
    )
}
