@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.GetSlicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property mobileNetworkName The name of the mobile network.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sliceName The name of the network slice.
 */
public data class GetSlicePlainArgs(
    public val mobileNetworkName: String,
    public val resourceGroupName: String,
    public val sliceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.GetSlicePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.GetSlicePlainArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.GetSlicePlainArgs.builder()
            .mobileNetworkName(mobileNetworkName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sliceName(sliceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSlicePlainArgs].
 */
@PulumiTagMarker
public class GetSlicePlainArgsBuilder internal constructor() {
    private var mobileNetworkName: String? = null

    private var resourceGroupName: String? = null

    private var sliceName: String? = null

    /**
     * @param value The name of the mobile network.
     */
    @JvmName("lbfkunatwvludonm")
    public suspend fun mobileNetworkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.mobileNetworkName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ietgshugxhtwjclc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the network slice.
     */
    @JvmName("amhcgwhxwcgcoonv")
    public suspend fun sliceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sliceName = mapped
    }

    internal fun build(): GetSlicePlainArgs = GetSlicePlainArgs(
        mobileNetworkName = mobileNetworkName ?: throw PulumiNullFieldException("mobileNetworkName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        sliceName = sliceName ?: throw PulumiNullFieldException("sliceName"),
    )
}
