@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.HttpsServerCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * HTTPS server certificate configuration.
 * @property certificateUrl The certificate URL, unversioned. For example: https://contosovault.vault.azure.net/certificates/ingress.
 */
public data class HttpsServerCertificateArgs(
    public val certificateUrl: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.HttpsServerCertificateArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.HttpsServerCertificateArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.HttpsServerCertificateArgs.builder()
            .certificateUrl(certificateUrl.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HttpsServerCertificateArgs].
 */
@PulumiTagMarker
public class HttpsServerCertificateArgsBuilder internal constructor() {
    private var certificateUrl: Output<String>? = null

    /**
     * @param value The certificate URL, unversioned. For example: https://contosovault.vault.azure.net/certificates/ingress.
     */
    @JvmName("ouejvlqncpgdubpb")
    public suspend fun certificateUrl(`value`: Output<String>) {
        this.certificateUrl = value
    }

    /**
     * @param value The certificate URL, unversioned. For example: https://contosovault.vault.azure.net/certificates/ingress.
     */
    @JvmName("tygwrhgbmrnlfipm")
    public suspend fun certificateUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificateUrl = mapped
    }

    internal fun build(): HttpsServerCertificateArgs = HttpsServerCertificateArgs(
        certificateUrl = certificateUrl ?: throw PulumiNullFieldException("certificateUrl"),
    )
}
