@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.PccRuleQosPolicyArgs.builder
import com.pulumi.azurenative.mobilenetwork.kotlin.enums.PreemptionCapability
import com.pulumi.azurenative.mobilenetwork.kotlin.enums.PreemptionVulnerability
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Data flow policy rule QoS policy
 * @property allocationAndRetentionPriorityLevel QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemptionCapability` and `preemptionVulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `5qi` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
 * @property fiveQi 5G QoS Flow Indicator value. The 5QI identifies a specific QoS forwarding treatment to be provided to a flow. See 3GPP TS23.501 section 5.7.2.1 for a full description of the 5QI parameter, and table 5.7.4-1 for the definition the 5QI values.
 * @property guaranteedBitRate The guaranteed bit rate (GBR) for all service data flows that use this data flow policy rule. This is an optional setting. If you do not provide a value, there will be no GBR set for the data flow policy rule that uses this QoS definition.
 * @property maximumBitRate The maximum bit rate (MBR) for all service data flows that use this data flow policy rule or service.
 * @property preemptionCapability QoS Flow preemption capability. The preemption capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
 * @property preemptionVulnerability QoS Flow preemption vulnerability. The preemption vulnerability of a QoS Flow controls whether it can be preempted by a QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
 */
public data class PccRuleQosPolicyArgs(
    public val allocationAndRetentionPriorityLevel: Output<Int>? = null,
    public val fiveQi: Output<Int>? = null,
    public val guaranteedBitRate: Output<AmbrArgs>? = null,
    public val maximumBitRate: Output<AmbrArgs>,
    public val preemptionCapability: Output<Either<String, PreemptionCapability>>? = null,
    public val preemptionVulnerability: Output<Either<String, PreemptionVulnerability>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.PccRuleQosPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.PccRuleQosPolicyArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.PccRuleQosPolicyArgs.builder()
            .allocationAndRetentionPriorityLevel(
                allocationAndRetentionPriorityLevel?.applyValue({ args0 ->
                    args0
                }),
            )
            .fiveQi(fiveQi?.applyValue({ args0 -> args0 }))
            .guaranteedBitRate(guaranteedBitRate?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .maximumBitRate(maximumBitRate.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .preemptionCapability(
                preemptionCapability?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .preemptionVulnerability(
                preemptionVulnerability?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [PccRuleQosPolicyArgs].
 */
@PulumiTagMarker
public class PccRuleQosPolicyArgsBuilder internal constructor() {
    private var allocationAndRetentionPriorityLevel: Output<Int>? = null

    private var fiveQi: Output<Int>? = null

    private var guaranteedBitRate: Output<AmbrArgs>? = null

    private var maximumBitRate: Output<AmbrArgs>? = null

    private var preemptionCapability: Output<Either<String, PreemptionCapability>>? = null

    private var preemptionVulnerability: Output<Either<String, PreemptionVulnerability>>? = null

    /**
     * @param value QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemptionCapability` and `preemptionVulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `5qi` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
     */
    @JvmName("noobljtxursrdbll")
    public suspend fun allocationAndRetentionPriorityLevel(`value`: Output<Int>) {
        this.allocationAndRetentionPriorityLevel = value
    }

    /**
     * @param value 5G QoS Flow Indicator value. The 5QI identifies a specific QoS forwarding treatment to be provided to a flow. See 3GPP TS23.501 section 5.7.2.1 for a full description of the 5QI parameter, and table 5.7.4-1 for the definition the 5QI values.
     */
    @JvmName("hixjvnrltysfmxco")
    public suspend fun fiveQi(`value`: Output<Int>) {
        this.fiveQi = value
    }

    /**
     * @param value The guaranteed bit rate (GBR) for all service data flows that use this data flow policy rule. This is an optional setting. If you do not provide a value, there will be no GBR set for the data flow policy rule that uses this QoS definition.
     */
    @JvmName("omcbpxxrrbltmtee")
    public suspend fun guaranteedBitRate(`value`: Output<AmbrArgs>) {
        this.guaranteedBitRate = value
    }

    /**
     * @param value The maximum bit rate (MBR) for all service data flows that use this data flow policy rule or service.
     */
    @JvmName("dwtgpdvoixcvosie")
    public suspend fun maximumBitRate(`value`: Output<AmbrArgs>) {
        this.maximumBitRate = value
    }

    /**
     * @param value QoS Flow preemption capability. The preemption capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
     */
    @JvmName("rydvpduitxolmvin")
    public suspend fun preemptionCapability(`value`: Output<Either<String, PreemptionCapability>>) {
        this.preemptionCapability = value
    }

    /**
     * @param value QoS Flow preemption vulnerability. The preemption vulnerability of a QoS Flow controls whether it can be preempted by a QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
     */
    @JvmName("hteaxyfpstqihpjr")
    public suspend
    fun preemptionVulnerability(`value`: Output<Either<String, PreemptionVulnerability>>) {
        this.preemptionVulnerability = value
    }

    /**
     * @param value QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemptionCapability` and `preemptionVulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `5qi` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
     */
    @JvmName("iluwkpdynmqcemyw")
    public suspend fun allocationAndRetentionPriorityLevel(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allocationAndRetentionPriorityLevel = mapped
    }

    /**
     * @param value 5G QoS Flow Indicator value. The 5QI identifies a specific QoS forwarding treatment to be provided to a flow. See 3GPP TS23.501 section 5.7.2.1 for a full description of the 5QI parameter, and table 5.7.4-1 for the definition the 5QI values.
     */
    @JvmName("vtwrbokqaaubvxgn")
    public suspend fun fiveQi(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fiveQi = mapped
    }

    /**
     * @param value The guaranteed bit rate (GBR) for all service data flows that use this data flow policy rule. This is an optional setting. If you do not provide a value, there will be no GBR set for the data flow policy rule that uses this QoS definition.
     */
    @JvmName("nomyhakexuogknsx")
    public suspend fun guaranteedBitRate(`value`: AmbrArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.guaranteedBitRate = mapped
    }

    /**
     * @param argument The guaranteed bit rate (GBR) for all service data flows that use this data flow policy rule. This is an optional setting. If you do not provide a value, there will be no GBR set for the data flow policy rule that uses this QoS definition.
     */
    @JvmName("mntoqgxmihpmsnpj")
    public suspend fun guaranteedBitRate(argument: suspend AmbrArgsBuilder.() -> Unit) {
        val toBeMapped = AmbrArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.guaranteedBitRate = mapped
    }

    /**
     * @param value The maximum bit rate (MBR) for all service data flows that use this data flow policy rule or service.
     */
    @JvmName("ioltocfqumxakrvf")
    public suspend fun maximumBitRate(`value`: AmbrArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maximumBitRate = mapped
    }

    /**
     * @param argument The maximum bit rate (MBR) for all service data flows that use this data flow policy rule or service.
     */
    @JvmName("rtojxhgyoffvybqq")
    public suspend fun maximumBitRate(argument: suspend AmbrArgsBuilder.() -> Unit) {
        val toBeMapped = AmbrArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.maximumBitRate = mapped
    }

    /**
     * @param value QoS Flow preemption capability. The preemption capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
     */
    @JvmName("pxnftapvofvidpgn")
    public suspend fun preemptionCapability(`value`: Either<String, PreemptionCapability>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preemptionCapability = mapped
    }

    /**
     * @param value QoS Flow preemption capability. The preemption capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
     */
    @JvmName("klarjqjokkrkawpg")
    public fun preemptionCapability(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PreemptionCapability>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preemptionCapability = mapped
    }

    /**
     * @param value QoS Flow preemption capability. The preemption capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
     */
    @JvmName("smducuybvdrnkwdy")
    public fun preemptionCapability(`value`: PreemptionCapability) {
        val toBeMapped = Either.ofRight<String, PreemptionCapability>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preemptionCapability = mapped
    }

    /**
     * @param value QoS Flow preemption vulnerability. The preemption vulnerability of a QoS Flow controls whether it can be preempted by a QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
     */
    @JvmName("sdvhxybwddlkqsor")
    public suspend fun preemptionVulnerability(`value`: Either<String, PreemptionVulnerability>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preemptionVulnerability = mapped
    }

    /**
     * @param value QoS Flow preemption vulnerability. The preemption vulnerability of a QoS Flow controls whether it can be preempted by a QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
     */
    @JvmName("rftashiewpikidif")
    public fun preemptionVulnerability(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PreemptionVulnerability>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preemptionVulnerability = mapped
    }

    /**
     * @param value QoS Flow preemption vulnerability. The preemption vulnerability of a QoS Flow controls whether it can be preempted by a QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
     */
    @JvmName("tbdcpfvtkygfatqf")
    public fun preemptionVulnerability(`value`: PreemptionVulnerability) {
        val toBeMapped = Either.ofRight<String, PreemptionVulnerability>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preemptionVulnerability = mapped
    }

    internal fun build(): PccRuleQosPolicyArgs = PccRuleQosPolicyArgs(
        allocationAndRetentionPriorityLevel = allocationAndRetentionPriorityLevel,
        fiveQi = fiveQi,
        guaranteedBitRate = guaranteedBitRate,
        maximumBitRate = maximumBitRate ?: throw PulumiNullFieldException("maximumBitRate"),
        preemptionCapability = preemptionCapability,
        preemptionVulnerability = preemptionVulnerability,
    )
}
