@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.PortRangeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Range of port numbers to use as translated ports on each translated address.
 * If not specified and NAPT is enabled, this range defaults to 1,024 - 49,999.
 * (Ports under 1,024 should not be used because these are special purpose ports reserved by IANA. Ports 50,000 and above are reserved for non-NAPT use.)
 * @property maxPort The maximum port number
 * @property minPort The minimum port number
 */
public data class PortRangeArgs(
    public val maxPort: Output<Int>? = null,
    public val minPort: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.PortRangeArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.PortRangeArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.PortRangeArgs.builder()
            .maxPort(maxPort?.applyValue({ args0 -> args0 }))
            .minPort(minPort?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PortRangeArgs].
 */
@PulumiTagMarker
public class PortRangeArgsBuilder internal constructor() {
    private var maxPort: Output<Int>? = null

    private var minPort: Output<Int>? = null

    /**
     * @param value The maximum port number
     */
    @JvmName("ececyfxxljbywqyn")
    public suspend fun maxPort(`value`: Output<Int>) {
        this.maxPort = value
    }

    /**
     * @param value The minimum port number
     */
    @JvmName("ceibxkfqunepncbj")
    public suspend fun minPort(`value`: Output<Int>) {
        this.minPort = value
    }

    /**
     * @param value The maximum port number
     */
    @JvmName("bdueakbvowafiexu")
    public suspend fun maxPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxPort = mapped
    }

    /**
     * @param value The minimum port number
     */
    @JvmName("jclqjcyosgfnmdkv")
    public suspend fun minPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minPort = mapped
    }

    internal fun build(): PortRangeArgs = PortRangeArgs(
        maxPort = maxPort,
        minPort = minPort,
    )
}
