@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.ServiceResourceIdArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Reference to a service resource.
 * @property id Service resource ID.
 */
public data class ServiceResourceIdArgs(
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.ServiceResourceIdArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.ServiceResourceIdArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.ServiceResourceIdArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceResourceIdArgs].
 */
@PulumiTagMarker
public class ServiceResourceIdArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Service resource ID.
     */
    @JvmName("ejcwemfgbcsbghnw")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Service resource ID.
     */
    @JvmName("utfxbcbgirvxsvud")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): ServiceResourceIdArgs = ServiceResourceIdArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
