@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An Azure key vault key.
 * @property keyUrl The key URL, unversioned. For example: https://contosovault.vault.azure.net/keys/azureKey.
 */
public data class KeyVaultKeyResponse(
    public val keyUrl: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.outputs.KeyVaultKeyResponse):
            KeyVaultKeyResponse = KeyVaultKeyResponse(
            keyUrl = javaType.keyUrl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
