@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The platform where the packet core is deployed.
 * @property azureStackEdgeDevice The Azure Stack Edge device where the packet core is deployed. If the device is part of a fault tolerant pair, either device in the pair can be specified.
 * @property azureStackEdgeDevices The Azure Stack Edge devices where the packet core is deployed. If the packet core is deployed across multiple devices, all devices will appear in this list.
 * @property azureStackHciCluster The Azure Stack HCI cluster where the packet core is deployed.
 * @property connectedCluster Azure Arc connected cluster where the packet core is deployed.
 * @property customLocation Azure Arc custom location where the packet core is deployed.
 * @property type The platform type where packet core is deployed.
 */
public data class PlatformConfigurationResponse(
    public val azureStackEdgeDevice: AzureStackEdgeDeviceResourceIdResponse? = null,
    public val azureStackEdgeDevices: List<AzureStackEdgeDeviceResourceIdResponse>,
    public val azureStackHciCluster: AzureStackHCIClusterResourceIdResponse? = null,
    public val connectedCluster: ConnectedClusterResourceIdResponse? = null,
    public val customLocation: CustomLocationResourceIdResponse? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.outputs.PlatformConfigurationResponse):
            PlatformConfigurationResponse = PlatformConfigurationResponse(
            azureStackEdgeDevice = javaType.azureStackEdgeDevice().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.mobilenetwork.kotlin.outputs.AzureStackEdgeDeviceResourceIdResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            azureStackEdgeDevices = javaType.azureStackEdgeDevices().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.mobilenetwork.kotlin.outputs.AzureStackEdgeDeviceResourceIdResponse.Companion.toKotlin(args0)
                })
            }),
            azureStackHciCluster = javaType.azureStackHciCluster().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.mobilenetwork.kotlin.outputs.AzureStackHCIClusterResourceIdResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            connectedCluster = javaType.connectedCluster().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.mobilenetwork.kotlin.outputs.ConnectedClusterResourceIdResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            customLocation = javaType.customLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.mobilenetwork.kotlin.outputs.CustomLocationResourceIdResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
