@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Range of port numbers to use as translated ports on each translated address.
 * If not specified and NAPT is enabled, this range defaults to 1,024 - 49,999.
 * (Ports under 1,024 should not be used because these are special purpose ports reserved by IANA. Ports 50,000 and above are reserved for non-NAPT use.)
 * @property maxPort The maximum port number
 * @property minPort The minimum port number
 */
public data class PortRangeResponse(
    public val maxPort: Int? = null,
    public val minPort: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.outputs.PortRangeResponse):
            PortRangeResponse = PortRangeResponse(
            maxPort = javaType.maxPort().map({ args0 -> args0 }).orElse(null),
            minPort = javaType.minPort().map({ args0 -> args0 }).orElse(null),
        )
    }
}
