@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Data flow template
 * @property direction The direction of this flow.
 * @property ports The port(s) to which UEs will connect for this flow. You can specify zero or more ports or port ranges. If you specify one or more ports or port ranges then you must specify a value other than `ip` in the `protocol` field. This is an optional setting. If you do not specify it then connections will be allowed on all ports. Port ranges must be specified as <FirstPort>-<LastPort>. For example: [`8080`, `8082-8085`].
 * @property protocol A list of the allowed protocol(s) for this flow. If you want this flow to be able to use any protocol within the internet protocol suite, use the value `ip`. If you only want to allow a selection of protocols, you must use the corresponding IANA Assigned Internet Protocol Number for each protocol, as described in https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml. For example, for UDP, you must use 17. If you use the value `ip` then you must leave the field `port` unspecified.
 * @property remoteIpList The remote IP address(es) to which UEs will connect for this flow. If you want to allow connections on any IP address, use the value `any`. Otherwise, you must provide each of the remote IP addresses to which the packet core instance will connect for this flow. You must provide each IP address in CIDR notation, including the netmask (for example, 192.0.2.54/24).
 * @property templateName The name of the data flow template. This must be unique within the parent data flow policy rule. You must not use any of the following reserved strings - `default`, `requested` or `service`.
 */
public data class ServiceDataFlowTemplateResponse(
    public val direction: String,
    public val ports: List<String>? = null,
    public val protocol: List<String>,
    public val remoteIpList: List<String>,
    public val templateName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.outputs.ServiceDataFlowTemplateResponse):
            ServiceDataFlowTemplateResponse = ServiceDataFlowTemplateResponse(
            direction = javaType.direction(),
            ports = javaType.ports().map({ args0 -> args0 }),
            protocol = javaType.protocol().map({ args0 -> args0 }),
            remoteIpList = javaType.remoteIpList().map({ args0 -> args0 }),
            templateName = javaType.templateName(),
        )
    }
}
