@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin

import com.pulumi.azurenative.mobilepacketcore.ClusterServiceArgs.builder
import com.pulumi.azurenative.mobilepacketcore.kotlin.enums.SkuDeploymentType
import com.pulumi.azurenative.mobilepacketcore.kotlin.inputs.ClusterServiceAksClusterDataArgs
import com.pulumi.azurenative.mobilepacketcore.kotlin.inputs.ClusterServiceNexusAksClusterDataArgs
import com.pulumi.azurenative.mobilepacketcore.kotlin.inputs.QualifiedComponentDeploymentParametersArgs
import com.pulumi.azurenative.mobilepacketcore.kotlin.inputs.QualifiedComponentDeploymentParametersArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Azure for Operators 5G Core Cluster Service Resource
 * Azure REST API version: 2023-10-15-preview.
 * ## Example Usage
 * ### ClusterServices_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var clusterService = new AzureNative.MobilePacketCore.ClusterService("clusterService", new()
 *     {
 *         ClusterServiceName = "clusterService1",
 *         ClusterTypeSpecificData = new AzureNative.MobilePacketCore.Inputs.ClusterServiceNexusAksClusterDataArgs
 *         {
 *             CustomLocationId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ExtendedLocation/customLocations/cluster124Location",
 *             Type = "NexusAks",
 *         },
 *         ComponentParameters = new[]
 *         {
 *             new AzureNative.MobilePacketCore.Inputs.QualifiedComponentDeploymentParametersArgs
 *             {
 *                 Parameters = "{\"global\": {\"registry\": {\"docker\": []}}}",
 *                 Secrets = "{\"global\": {\"secret\": {\"secretValue\": []}}}",
 *                 Type = "fed-crds",
 *             },
 *         },
 *         DeploymentType = AzureNative.MobilePacketCore.SkuDeploymentType.Production,
 *         Location = "eastus",
 *         ReleaseVersion = "4.3.0-alpha",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilepacketcore/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilepacketcore.NewClusterService(ctx, "clusterService", &mobilepacketcore.ClusterServiceArgs{
 * 			ClusterServiceName: pulumi.String("clusterService1"),
 * 			ClusterTypeSpecificData: mobilepacketcore.ClusterServiceNexusAksClusterData{
 * 				CustomLocationId: "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ExtendedLocation/customLocations/cluster124Location",
 * 				Type:             "NexusAks",
 * 			},
 * 			ComponentParameters: mobilepacketcore.QualifiedComponentDeploymentParametersArray{
 * 				&mobilepacketcore.QualifiedComponentDeploymentParametersArgs{
 * 					Parameters: pulumi.String("{\"global\": {\"registry\": {\"docker\": []}}}"),
 * 					Secrets:    pulumi.String("{\"global\": {\"secret\": {\"secretValue\": []}}}"),
 * 					Type:       pulumi.String("fed-crds"),
 * 				},
 * 			},
 * 			DeploymentType:    pulumi.String(mobilepacketcore.SkuDeploymentTypeProduction),
 * 			Location:          pulumi.String("eastus"),
 * 			ReleaseVersion:    pulumi.String("4.3.0-alpha"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilepacketcore.ClusterService;
 * import com.pulumi.azurenative.mobilepacketcore.ClusterServiceArgs;
 * import com.pulumi.azurenative.mobilepacketcore.inputs.QualifiedComponentDeploymentParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var clusterService = new ClusterService("clusterService", ClusterServiceArgs.builder()
 *             .clusterServiceName("clusterService1")
 *             .clusterTypeSpecificData(ClusterServiceNexusAksClusterDataArgs.builder()
 *                 .customLocationId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ExtendedLocation/customLocations/cluster124Location")
 *                 .type("NexusAks")
 *                 .build())
 *             .componentParameters(QualifiedComponentDeploymentParametersArgs.builder()
 *                 .parameters("{\"global\": {\"registry\": {\"docker\": []}}}")
 *                 .secrets("{\"global\": {\"secret\": {\"secretValue\": []}}}")
 *                 .type("fed-crds")
 *                 .build())
 *             .deploymentType("Production")
 *             .location("eastus")
 *             .releaseVersion("4.3.0-alpha")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilepacketcore:ClusterService clusterService1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobilePacketCore/clusterServices/{clusterServiceName}
 * ```
 * @property clusterServiceName The name of the Cluster Service
 * @property clusterTypeSpecificData Cluster type specific data.  Contents depend on the cluster type
 * @property componentParameters Azure for Operators 5G Core Local PaaS component parameters.  One set per component type
 * @property deploymentType Cluster type (Lab or Production)
 * @property location The geo-location where the resource lives
 * @property releaseVersion Azure for Operators 5G Core Release Version.  This is applied to all platform as a service (PaaS) components and running workloads in this cluster
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class ClusterServiceArgs(
    public val clusterServiceName: Output<String>? = null,
    public val clusterTypeSpecificData:
    Output<Either<ClusterServiceAksClusterDataArgs, ClusterServiceNexusAksClusterDataArgs>>? =
        null,
    public val componentParameters: Output<List<QualifiedComponentDeploymentParametersArgs>>? = null,
    public val deploymentType: Output<Either<String, SkuDeploymentType>>? = null,
    public val location: Output<String>? = null,
    public val releaseVersion: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.mobilepacketcore.ClusterServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilepacketcore.ClusterServiceArgs =
        com.pulumi.azurenative.mobilepacketcore.ClusterServiceArgs.builder()
            .clusterServiceName(clusterServiceName?.applyValue({ args0 -> args0 }))
            .clusterTypeSpecificData(
                clusterTypeSpecificData?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .componentParameters(
                componentParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .deploymentType(
                deploymentType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .releaseVersion(releaseVersion?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ClusterServiceArgs].
 */
@PulumiTagMarker
public class ClusterServiceArgsBuilder internal constructor() {
    private var clusterServiceName: Output<String>? = null

    private var clusterTypeSpecificData:
        Output<Either<ClusterServiceAksClusterDataArgs, ClusterServiceNexusAksClusterDataArgs>>? =
        null

    private var componentParameters: Output<List<QualifiedComponentDeploymentParametersArgs>>? = null

    private var deploymentType: Output<Either<String, SkuDeploymentType>>? = null

    private var location: Output<String>? = null

    private var releaseVersion: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the Cluster Service
     */
    @JvmName("qidkqwfqvspjfmpb")
    public suspend fun clusterServiceName(`value`: Output<String>) {
        this.clusterServiceName = value
    }

    /**
     * @param value Cluster type specific data.  Contents depend on the cluster type
     */
    @JvmName("pcvyobrhcqytqdct")
    public suspend
    fun clusterTypeSpecificData(`value`: Output<Either<ClusterServiceAksClusterDataArgs, ClusterServiceNexusAksClusterDataArgs>>) {
        this.clusterTypeSpecificData = value
    }

    /**
     * @param value Azure for Operators 5G Core Local PaaS component parameters.  One set per component type
     */
    @JvmName("wplbaqgdwqiccjdq")
    public suspend
    fun componentParameters(`value`: Output<List<QualifiedComponentDeploymentParametersArgs>>) {
        this.componentParameters = value
    }

    @JvmName("lqyokhnhujttdcft")
    public suspend fun componentParameters(
        vararg
        values: Output<QualifiedComponentDeploymentParametersArgs>,
    ) {
        this.componentParameters = Output.all(values.asList())
    }

    /**
     * @param values Azure for Operators 5G Core Local PaaS component parameters.  One set per component type
     */
    @JvmName("kfgsuiknicordrks")
    public suspend
    fun componentParameters(values: List<Output<QualifiedComponentDeploymentParametersArgs>>) {
        this.componentParameters = Output.all(values)
    }

    /**
     * @param value Cluster type (Lab or Production)
     */
    @JvmName("kvmqjhxsymuxiwlf")
    public suspend fun deploymentType(`value`: Output<Either<String, SkuDeploymentType>>) {
        this.deploymentType = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("yncifsuviybhuuwp")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Azure for Operators 5G Core Release Version.  This is applied to all platform as a service (PaaS) components and running workloads in this cluster
     */
    @JvmName("myuhprmpoyeiagdu")
    public suspend fun releaseVersion(`value`: Output<String>) {
        this.releaseVersion = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("arqutvooocrytjlc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("illeijkcncsblppy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the Cluster Service
     */
    @JvmName("owiqtpihpiqjpdld")
    public suspend fun clusterServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterServiceName = mapped
    }

    /**
     * @param value Cluster type specific data.  Contents depend on the cluster type
     */
    @JvmName("fpwybgclnhmqfuak")
    public suspend
    fun clusterTypeSpecificData(`value`: Either<ClusterServiceAksClusterDataArgs, ClusterServiceNexusAksClusterDataArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterTypeSpecificData = mapped
    }

    /**
     * @param value Cluster type specific data.  Contents depend on the cluster type
     */
    @JvmName("djjbpnrkawgmcpig")
    public fun clusterTypeSpecificData(`value`: ClusterServiceAksClusterDataArgs) {
        val toBeMapped = Either.ofLeft<ClusterServiceAksClusterDataArgs,
            ClusterServiceNexusAksClusterDataArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterTypeSpecificData = mapped
    }

    /**
     * @param value Cluster type specific data.  Contents depend on the cluster type
     */
    @JvmName("sxjbhbokcmnrifwg")
    public fun clusterTypeSpecificData(`value`: ClusterServiceNexusAksClusterDataArgs) {
        val toBeMapped = Either.ofRight<ClusterServiceAksClusterDataArgs,
            ClusterServiceNexusAksClusterDataArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterTypeSpecificData = mapped
    }

    /**
     * @param value Azure for Operators 5G Core Local PaaS component parameters.  One set per component type
     */
    @JvmName("vtyagrfwwbvgulqd")
    public suspend
    fun componentParameters(`value`: List<QualifiedComponentDeploymentParametersArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.componentParameters = mapped
    }

    /**
     * @param argument Azure for Operators 5G Core Local PaaS component parameters.  One set per component type
     */
    @JvmName("uiicusrndnekewtp")
    public suspend
    fun componentParameters(argument: List<suspend QualifiedComponentDeploymentParametersArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            QualifiedComponentDeploymentParametersArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.componentParameters = mapped
    }

    /**
     * @param argument Azure for Operators 5G Core Local PaaS component parameters.  One set per component type
     */
    @JvmName("deelukyiijfjkexq")
    public suspend fun componentParameters(
        vararg
        argument: suspend QualifiedComponentDeploymentParametersArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            QualifiedComponentDeploymentParametersArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.componentParameters = mapped
    }

    /**
     * @param argument Azure for Operators 5G Core Local PaaS component parameters.  One set per component type
     */
    @JvmName("peudycaxnrlimsqh")
    public suspend
    fun componentParameters(argument: suspend QualifiedComponentDeploymentParametersArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            QualifiedComponentDeploymentParametersArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.componentParameters = mapped
    }

    /**
     * @param values Azure for Operators 5G Core Local PaaS component parameters.  One set per component type
     */
    @JvmName("xvuppbyrsmsdyhuc")
    public suspend fun componentParameters(
        vararg
        values: QualifiedComponentDeploymentParametersArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.componentParameters = mapped
    }

    /**
     * @param value Cluster type (Lab or Production)
     */
    @JvmName("doakfmlolaununpn")
    public suspend fun deploymentType(`value`: Either<String, SkuDeploymentType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentType = mapped
    }

    /**
     * @param value Cluster type (Lab or Production)
     */
    @JvmName("mdfnqtfiwtsfabss")
    public fun deploymentType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SkuDeploymentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deploymentType = mapped
    }

    /**
     * @param value Cluster type (Lab or Production)
     */
    @JvmName("osffifwohdvumhmr")
    public fun deploymentType(`value`: SkuDeploymentType) {
        val toBeMapped = Either.ofRight<String, SkuDeploymentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deploymentType = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("kebjykuvnfqdblyt")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Azure for Operators 5G Core Release Version.  This is applied to all platform as a service (PaaS) components and running workloads in this cluster
     */
    @JvmName("vsajpassaojhkhns")
    public suspend fun releaseVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.releaseVersion = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wkadmnxyixosquvn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("hkpausibtbqotuyl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("hxpqydjlwclsllif")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ClusterServiceArgs = ClusterServiceArgs(
        clusterServiceName = clusterServiceName,
        clusterTypeSpecificData = clusterTypeSpecificData,
        componentParameters = componentParameters,
        deploymentType = deploymentType,
        location = location,
        releaseVersion = releaseVersion,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
