@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin

import com.pulumi.azurenative.mobilepacketcore.NetworkFunctionArgs.builder
import com.pulumi.azurenative.mobilepacketcore.kotlin.enums.NetworkFunctionAdministrativeState
import com.pulumi.azurenative.mobilepacketcore.kotlin.enums.NetworkFunctionType
import com.pulumi.azurenative.mobilepacketcore.kotlin.enums.SkuDefinitions
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * AO5GC Network Function Resource
 * Azure REST API version: 2023-05-15-preview.
 * ## Example Usage
 * ### NetworkFunctions_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkFunction = new AzureNative.MobilePacketCore.NetworkFunction("networkFunction", new()
 *     {
 *         Capacity = 100000,
 *         DeploymentNotes = "string",
 *         Location = "eastus",
 *         NetworkFunctionAdministrativeState = AzureNative.MobilePacketCore.NetworkFunctionAdministrativeState.Commissioned,
 *         NetworkFunctionName = "nf1",
 *         NetworkFunctionType = AzureNative.MobilePacketCore.NetworkFunctionType.SMF,
 *         ResourceGroupName = "rg1",
 *         Sku = AzureNative.MobilePacketCore.SkuDefinitions.NexusProduction,
 *         UserDescription = "string",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilepacketcore/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilepacketcore.NewNetworkFunction(ctx, "networkFunction", &mobilepacketcore.NetworkFunctionArgs{
 * 			Capacity:                           pulumi.Int(100000),
 * 			DeploymentNotes:                    pulumi.String("string"),
 * 			Location:                           pulumi.String("eastus"),
 * 			NetworkFunctionAdministrativeState: pulumi.String(mobilepacketcore.NetworkFunctionAdministrativeStateCommissioned),
 * 			NetworkFunctionName:                pulumi.String("nf1"),
 * 			NetworkFunctionType:                pulumi.String(mobilepacketcore.NetworkFunctionTypeSMF),
 * 			ResourceGroupName:                  pulumi.String("rg1"),
 * 			Sku:                                pulumi.String(mobilepacketcore.SkuDefinitionsNexusProduction),
 * 			UserDescription:                    pulumi.String("string"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilepacketcore.NetworkFunction;
 * import com.pulumi.azurenative.mobilepacketcore.NetworkFunctionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkFunction = new NetworkFunction("networkFunction", NetworkFunctionArgs.builder()
 *             .capacity(100000)
 *             .deploymentNotes("string")
 *             .location("eastus")
 *             .networkFunctionAdministrativeState("Commissioned")
 *             .networkFunctionName("nf1")
 *             .networkFunctionType("SMF")
 *             .resourceGroupName("rg1")
 *             .sku("NexusProduction")
 *             .userDescription("string")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilepacketcore:NetworkFunction nf1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobilePacketCore/networkFunctions/{networkFunctionName}
 * ```
 * @property capacity Capacity of the network function in units of 10000.  This represents the session count or the Simultaneously Attached Users (SAU) count as applicable
 * @property deploymentNotes User provided deployment notes.  This is used to optionally provide details about the NF deployment
 * @property location The geo-location where the resource lives
 * @property networkFunctionAdministrativeState Administrative state of the network function
 * @property networkFunctionName The name of the network function
 * @property networkFunctionType Type of network function
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku Provisioned SKU Value.
 * @property tags Resource tags.
 * @property userDescription User provided description
 */
public data class NetworkFunctionArgs(
    public val capacity: Output<Int>? = null,
    public val deploymentNotes: Output<String>? = null,
    public val location: Output<String>? = null,
    public val networkFunctionAdministrativeState:
    Output<Either<String, NetworkFunctionAdministrativeState>>? = null,
    public val networkFunctionName: Output<String>? = null,
    public val networkFunctionType: Output<Either<String, NetworkFunctionType>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<Either<String, SkuDefinitions>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userDescription: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.mobilepacketcore.NetworkFunctionArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilepacketcore.NetworkFunctionArgs =
        com.pulumi.azurenative.mobilepacketcore.NetworkFunctionArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .deploymentNotes(deploymentNotes?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .networkFunctionAdministrativeState(
                networkFunctionAdministrativeState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .networkFunctionName(networkFunctionName?.applyValue({ args0 -> args0 }))
            .networkFunctionType(
                networkFunctionType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(
                sku?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userDescription(userDescription?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkFunctionArgs].
 */
@PulumiTagMarker
public class NetworkFunctionArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var deploymentNotes: Output<String>? = null

    private var location: Output<String>? = null

    private var networkFunctionAdministrativeState:
        Output<Either<String, NetworkFunctionAdministrativeState>>? = null

    private var networkFunctionName: Output<String>? = null

    private var networkFunctionType: Output<Either<String, NetworkFunctionType>>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<Either<String, SkuDefinitions>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userDescription: Output<String>? = null

    /**
     * @param value Capacity of the network function in units of 10000.  This represents the session count or the Simultaneously Attached Users (SAU) count as applicable
     */
    @JvmName("rcrcjdbwaqbnydrw")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value User provided deployment notes.  This is used to optionally provide details about the NF deployment
     */
    @JvmName("vbkpsnhompjxdlid")
    public suspend fun deploymentNotes(`value`: Output<String>) {
        this.deploymentNotes = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("cuolaoyvitqiukqa")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Administrative state of the network function
     */
    @JvmName("pciykdfoksmuywwq")
    public suspend
    fun networkFunctionAdministrativeState(`value`: Output<Either<String, NetworkFunctionAdministrativeState>>) {
        this.networkFunctionAdministrativeState = value
    }

    /**
     * @param value The name of the network function
     */
    @JvmName("fcbwqqtktptniniv")
    public suspend fun networkFunctionName(`value`: Output<String>) {
        this.networkFunctionName = value
    }

    /**
     * @param value Type of network function
     */
    @JvmName("yuksaofyqbraqexm")
    public suspend fun networkFunctionType(`value`: Output<Either<String, NetworkFunctionType>>) {
        this.networkFunctionType = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ovqcapktlubjhluu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Provisioned SKU Value.
     */
    @JvmName("hkfkocvppceejctb")
    public suspend fun sku(`value`: Output<Either<String, SkuDefinitions>>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("poamnbidrlicgpce")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value User provided description
     */
    @JvmName("semtmfqdeavoefxj")
    public suspend fun userDescription(`value`: Output<String>) {
        this.userDescription = value
    }

    /**
     * @param value Capacity of the network function in units of 10000.  This represents the session count or the Simultaneously Attached Users (SAU) count as applicable
     */
    @JvmName("upstoueryjveteny")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value User provided deployment notes.  This is used to optionally provide details about the NF deployment
     */
    @JvmName("cdgkonelvmhmerqi")
    public suspend fun deploymentNotes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentNotes = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("vbowpyxdkrvtshos")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Administrative state of the network function
     */
    @JvmName("pisrkqkmiedusblr")
    public suspend
    fun networkFunctionAdministrativeState(`value`: Either<String, NetworkFunctionAdministrativeState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkFunctionAdministrativeState = mapped
    }

    /**
     * @param value Administrative state of the network function
     */
    @JvmName("hbikumoqblcybawh")
    public fun networkFunctionAdministrativeState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NetworkFunctionAdministrativeState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkFunctionAdministrativeState = mapped
    }

    /**
     * @param value Administrative state of the network function
     */
    @JvmName("ptjmjlsdtqlvrtny")
    public fun networkFunctionAdministrativeState(`value`: NetworkFunctionAdministrativeState) {
        val toBeMapped = Either.ofRight<String, NetworkFunctionAdministrativeState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkFunctionAdministrativeState = mapped
    }

    /**
     * @param value The name of the network function
     */
    @JvmName("ieqjphbspgohfvci")
    public suspend fun networkFunctionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkFunctionName = mapped
    }

    /**
     * @param value Type of network function
     */
    @JvmName("prmblvtxvhktuluo")
    public suspend fun networkFunctionType(`value`: Either<String, NetworkFunctionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkFunctionType = mapped
    }

    /**
     * @param value Type of network function
     */
    @JvmName("jeydvcqsxouinvls")
    public fun networkFunctionType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NetworkFunctionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkFunctionType = mapped
    }

    /**
     * @param value Type of network function
     */
    @JvmName("cdcaqjamwgjbsmem")
    public fun networkFunctionType(`value`: NetworkFunctionType) {
        val toBeMapped = Either.ofRight<String, NetworkFunctionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkFunctionType = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tnpivsfbxdbnmpbl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Provisioned SKU Value.
     */
    @JvmName("hoogljbxwbvjxpwh")
    public suspend fun sku(`value`: Either<String, SkuDefinitions>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param value Provisioned SKU Value.
     */
    @JvmName("jxspciejfdvulrxp")
    public fun sku(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SkuDefinitions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param value Provisioned SKU Value.
     */
    @JvmName("yioyndhgsjxqirph")
    public fun sku(`value`: SkuDefinitions) {
        val toBeMapped = Either.ofRight<String, SkuDefinitions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("fyffovmpljupuvwe")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("bwxgibpbchkipgwf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value User provided description
     */
    @JvmName("degymsavaeyvdapi")
    public suspend fun userDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userDescription = mapped
    }

    internal fun build(): NetworkFunctionArgs = NetworkFunctionArgs(
        capacity = capacity,
        deploymentNotes = deploymentNotes,
        location = location,
        networkFunctionAdministrativeState = networkFunctionAdministrativeState,
        networkFunctionName = networkFunctionName,
        networkFunctionType = networkFunctionType,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
        userDescription = userDescription,
    )
}
