@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin

import com.pulumi.azurenative.mobilepacketcore.UpfDeploymentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Azure for Operators 5G Core User Plane Function (UPF) Deployment Resource
 * Azure REST API version: 2023-10-15-preview.
 * ## Example Usage
 * ### UpfDeployments_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var upfDeployment = new AzureNative.MobilePacketCore.UpfDeployment("upfDeployment", new()
 *     {
 *         ClusterService = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobilePacketCore/clusterServices/byoCluster",
 *         ComponentParameters = "{\"global\": {\"registry\": {\"docker\": []}}}",
 *         Location = "eastus",
 *         ResourceGroupName = "rg1",
 *         SecretsParameters = "{\"global\": {\"secret\": {\"secretValue\": []}}}",
 *         UpfDeploymentName = "upfDeployment1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilepacketcore/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilepacketcore.NewUpfDeployment(ctx, "upfDeployment", &mobilepacketcore.UpfDeploymentArgs{
 * 			ClusterService:      pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobilePacketCore/clusterServices/byoCluster"),
 * 			ComponentParameters: pulumi.String("{\"global\": {\"registry\": {\"docker\": []}}}"),
 * 			Location:            pulumi.String("eastus"),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			SecretsParameters:   pulumi.String("{\"global\": {\"secret\": {\"secretValue\": []}}}"),
 * 			UpfDeploymentName:   pulumi.String("upfDeployment1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilepacketcore.UpfDeployment;
 * import com.pulumi.azurenative.mobilepacketcore.UpfDeploymentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var upfDeployment = new UpfDeployment("upfDeployment", UpfDeploymentArgs.builder()
 *             .clusterService("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobilePacketCore/clusterServices/byoCluster")
 *             .componentParameters("{\"global\": {\"registry\": {\"docker\": []}}}")
 *             .location("eastus")
 *             .resourceGroupName("rg1")
 *             .secretsParameters("{\"global\": {\"secret\": {\"secretValue\": []}}}")
 *             .upfDeploymentName("upfDeployment1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilepacketcore:UpfDeployment upfDeployment1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobilePacketCore/upfDeployments/{upfDeploymentName}
 * ```
 * @property clusterService Reference to cluster where the Network Function is deployed
 * @property componentParameters Azure for Operators 5G Core UPF component parameters
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property secretsParameters Azure for Operators 5G Core F secrets parameters
 * @property tags Resource tags.
 * @property upfDeploymentName The name of the UpfDeployment
 */
public data class UpfDeploymentArgs(
    public val clusterService: Output<String>? = null,
    public val componentParameters: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val secretsParameters: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val upfDeploymentName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.mobilepacketcore.UpfDeploymentArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilepacketcore.UpfDeploymentArgs =
        com.pulumi.azurenative.mobilepacketcore.UpfDeploymentArgs.builder()
            .clusterService(clusterService?.applyValue({ args0 -> args0 }))
            .componentParameters(componentParameters?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .secretsParameters(secretsParameters?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .upfDeploymentName(upfDeploymentName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UpfDeploymentArgs].
 */
@PulumiTagMarker
public class UpfDeploymentArgsBuilder internal constructor() {
    private var clusterService: Output<String>? = null

    private var componentParameters: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var secretsParameters: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var upfDeploymentName: Output<String>? = null

    /**
     * @param value Reference to cluster where the Network Function is deployed
     */
    @JvmName("ygvurmexinqqeiga")
    public suspend fun clusterService(`value`: Output<String>) {
        this.clusterService = value
    }

    /**
     * @param value Azure for Operators 5G Core UPF component parameters
     */
    @JvmName("srwpskgvqgoxdqci")
    public suspend fun componentParameters(`value`: Output<String>) {
        this.componentParameters = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("tvyjhyrccmattvyc")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ofxdrqdrvfysldqj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Azure for Operators 5G Core F secrets parameters
     */
    @JvmName("smfqovvpyxqdwidc")
    public suspend fun secretsParameters(`value`: Output<String>) {
        this.secretsParameters = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("kmtpxwrrxtpfobpr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the UpfDeployment
     */
    @JvmName("lwmjdkflkxnfcsuq")
    public suspend fun upfDeploymentName(`value`: Output<String>) {
        this.upfDeploymentName = value
    }

    /**
     * @param value Reference to cluster where the Network Function is deployed
     */
    @JvmName("iacvuobrjbshhool")
    public suspend fun clusterService(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterService = mapped
    }

    /**
     * @param value Azure for Operators 5G Core UPF component parameters
     */
    @JvmName("ejbakaejcmjiytqp")
    public suspend fun componentParameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.componentParameters = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("dedqjcideslanytm")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wddnkpefwoiuydrw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Azure for Operators 5G Core F secrets parameters
     */
    @JvmName("mywyrvrcuhjxjtrg")
    public suspend fun secretsParameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretsParameters = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qsissiwjiiuximml")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("dkbkclgbqkgdotwf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the UpfDeployment
     */
    @JvmName("oncmovkyyxqrqruf")
    public suspend fun upfDeploymentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upfDeploymentName = mapped
    }

    internal fun build(): UpfDeploymentArgs = UpfDeploymentArgs(
        clusterService = clusterService,
        componentParameters = componentParameters,
        location = location,
        resourceGroupName = resourceGroupName,
        secretsParameters = secretsParameters,
        tags = tags,
        upfDeploymentName = upfDeploymentName,
    )
}
