@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of network function
 */
public enum class NetworkFunctionType(
    public val javaValue: com.pulumi.azurenative.mobilepacketcore.enums.NetworkFunctionType,
) : ConvertibleToJava<com.pulumi.azurenative.mobilepacketcore.enums.NetworkFunctionType> {
    /**
     * Access and Mobility Function
     */
    AMF(com.pulumi.azurenative.mobilepacketcore.enums.NetworkFunctionType.AMF),

    /**
     * Session Management Function
     */
    SMF(com.pulumi.azurenative.mobilepacketcore.enums.NetworkFunctionType.SMF),

    /**
     * User Plane Function
     */
    UPF(com.pulumi.azurenative.mobilepacketcore.enums.NetworkFunctionType.UPF),

    /**
     * Network Repository Function
     */
    NRF(com.pulumi.azurenative.mobilepacketcore.enums.NetworkFunctionType.NRF),

    /**
     * Network Slice Selection Function
     */
    NSSF(com.pulumi.azurenative.mobilepacketcore.enums.NetworkFunctionType.NSSF),

    /**
     * Mobility Management Entity
     */
    MME(com.pulumi.azurenative.mobilepacketcore.enums.NetworkFunctionType.MME),

    /**
     * System Architecture Evolution Gateway Control Plane, control and user plane separation (CUPS) architecture
     */
    SaegwControlPlane(com.pulumi.azurenative.mobilepacketcore.enums.NetworkFunctionType.SaegwControlPlane),

    /**
     * System Architecture Evolution Gateway User Plane, control and user plane separation (CUPS) architecture
     */
    SaegwUserPlane(com.pulumi.azurenative.mobilepacketcore.enums.NetworkFunctionType.SaegwUserPlane),

    /**
     * System Architecture Evolution Gateway.  This combines the Serving Gateway (SGW) and the Packet Data Network Gateway (PGW) functionality
     */
    Saegw(com.pulumi.azurenative.mobilepacketcore.enums.NetworkFunctionType.Saegw),

    /**
     * Evolved Packet Data Gateway
     */
    EPDG(com.pulumi.azurenative.mobilepacketcore.enums.NetworkFunctionType.EPDG),

    /**
     * Non-3GPP Interworking Function
     */
    N3IWF(com.pulumi.azurenative.mobilepacketcore.enums.NetworkFunctionType.N3IWF),

    /**
     * Remote Platform As A Service Components
     */
    RemotePaaS(com.pulumi.azurenative.mobilepacketcore.enums.NetworkFunctionType.RemotePaaS),

    /**
     * Element Management System
     */
    EMS(com.pulumi.azurenative.mobilepacketcore.enums.NetworkFunctionType.EMS),

    /**
     * Operations and Policy Manager
     */
    OperationsPolicyManager(com.pulumi.azurenative.mobilepacketcore.enums.NetworkFunctionType.OperationsPolicyManager),
    ;

    override fun toJava(): com.pulumi.azurenative.mobilepacketcore.enums.NetworkFunctionType =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.mobilepacketcore.enums.NetworkFunctionType):
            NetworkFunctionType = NetworkFunctionType.values().first { it.javaValue == javaType }
    }
}
