@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Provisioned SKU Value.
 */
public enum class SkuDefinitions(
    public val javaValue: com.pulumi.azurenative.mobilepacketcore.enums.SkuDefinitions,
) : ConvertibleToJava<com.pulumi.azurenative.mobilepacketcore.enums.SkuDefinitions> {
    /**
     * Azure Lab SKU
     */
    AzureLab(com.pulumi.azurenative.mobilepacketcore.enums.SkuDefinitions.AzureLab),

    /**
     * Azure Production SKU
     */
    AzureProduction(com.pulumi.azurenative.mobilepacketcore.enums.SkuDefinitions.AzureProduction),

    /**
     * Nexus Lab SKU
     */
    NexusLab(com.pulumi.azurenative.mobilepacketcore.enums.SkuDefinitions.NexusLab),

    /**
     * Nexus Production SKU
     */
    NexusProduction(com.pulumi.azurenative.mobilepacketcore.enums.SkuDefinitions.NexusProduction),
    ;

    override fun toJava(): com.pulumi.azurenative.mobilepacketcore.enums.SkuDefinitions = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.mobilepacketcore.enums.SkuDefinitions):
            SkuDefinitions = SkuDefinitions.values().first { it.javaValue == javaType }
    }
}
