@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin.inputs

import com.pulumi.azurenative.mobilepacketcore.inputs.ClusterServiceAksClusterDataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * AKS Cluster specific data.
 * @property customLocationId Custom Location resource ID
 * @property type Cluster Type Definitions
 * Expected value is 'Aks'.
 */
public data class ClusterServiceAksClusterDataArgs(
    public val customLocationId: Output<String>,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.mobilepacketcore.inputs.ClusterServiceAksClusterDataArgs> {
    override fun toJava():
        com.pulumi.azurenative.mobilepacketcore.inputs.ClusterServiceAksClusterDataArgs =
        com.pulumi.azurenative.mobilepacketcore.inputs.ClusterServiceAksClusterDataArgs.builder()
            .customLocationId(customLocationId.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterServiceAksClusterDataArgs].
 */
@PulumiTagMarker
public class ClusterServiceAksClusterDataArgsBuilder internal constructor() {
    private var customLocationId: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Custom Location resource ID
     */
    @JvmName("cqvrlxfrqnisfqri")
    public suspend fun customLocationId(`value`: Output<String>) {
        this.customLocationId = value
    }

    /**
     * @param value Cluster Type Definitions
     * Expected value is 'Aks'.
     */
    @JvmName("vvhooghlvajlrxja")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Custom Location resource ID
     */
    @JvmName("edbtbkogkdsfwodx")
    public suspend fun customLocationId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customLocationId = mapped
    }

    /**
     * @param value Cluster Type Definitions
     * Expected value is 'Aks'.
     */
    @JvmName("ijqmdevgrhhraqgh")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ClusterServiceAksClusterDataArgs = ClusterServiceAksClusterDataArgs(
        customLocationId = customLocationId ?: throw PulumiNullFieldException("customLocationId"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
