@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin.inputs

import com.pulumi.azurenative.mobilepacketcore.inputs.GetNrfDeploymentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property nrfDeploymentName The name of the NrfDeployment
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetNrfDeploymentPlainArgs(
    public val nrfDeploymentName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.mobilepacketcore.inputs.GetNrfDeploymentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilepacketcore.inputs.GetNrfDeploymentPlainArgs =
        com.pulumi.azurenative.mobilepacketcore.inputs.GetNrfDeploymentPlainArgs.builder()
            .nrfDeploymentName(nrfDeploymentName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNrfDeploymentPlainArgs].
 */
@PulumiTagMarker
public class GetNrfDeploymentPlainArgsBuilder internal constructor() {
    private var nrfDeploymentName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the NrfDeployment
     */
    @JvmName("wdtvmjmxvcipkjsk")
    public suspend fun nrfDeploymentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.nrfDeploymentName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bfspqjdiyxgoirra")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNrfDeploymentPlainArgs = GetNrfDeploymentPlainArgs(
        nrfDeploymentName = nrfDeploymentName ?: throw PulumiNullFieldException("nrfDeploymentName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
