@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin

import com.pulumi.azurenative.monitor.AzureMonitorWorkspaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An Azure Monitor Workspace definition
 * Azure REST API version: 2023-04-03. Prior API version in Azure Native 1.x: 2021-06-03-preview.
 * ## Example Usage
 * ### Create or update an Azure Monitor Workspace
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureMonitorWorkspace = new AzureNative.Monitor.AzureMonitorWorkspace("azureMonitorWorkspace", new()
 *     {
 *         AzureMonitorWorkspaceName = "myAzureMonitorWorkspace",
 *         Location = "eastus",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/monitor/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := monitor.NewAzureMonitorWorkspace(ctx, "azureMonitorWorkspace", &monitor.AzureMonitorWorkspaceArgs{
 * 			AzureMonitorWorkspaceName: pulumi.String("myAzureMonitorWorkspace"),
 * 			Location:                  pulumi.String("eastus"),
 * 			ResourceGroupName:         pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.monitor.AzureMonitorWorkspace;
 * import com.pulumi.azurenative.monitor.AzureMonitorWorkspaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureMonitorWorkspace = new AzureMonitorWorkspace("azureMonitorWorkspace", AzureMonitorWorkspaceArgs.builder()
 *             .azureMonitorWorkspaceName("myAzureMonitorWorkspace")
 *             .location("eastus")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:monitor:AzureMonitorWorkspace myAzureMonitorWorkspace /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Monitor/accounts/{azureMonitorWorkspaceName}
 * ```
 * @property azureMonitorWorkspaceName The name of the Azure Monitor Workspace. The name is case insensitive
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class AzureMonitorWorkspaceArgs(
    public val azureMonitorWorkspaceName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.monitor.AzureMonitorWorkspaceArgs> {
    override fun toJava(): com.pulumi.azurenative.monitor.AzureMonitorWorkspaceArgs =
        com.pulumi.azurenative.monitor.AzureMonitorWorkspaceArgs.builder()
            .azureMonitorWorkspaceName(azureMonitorWorkspaceName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AzureMonitorWorkspaceArgs].
 */
@PulumiTagMarker
public class AzureMonitorWorkspaceArgsBuilder internal constructor() {
    private var azureMonitorWorkspaceName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the Azure Monitor Workspace. The name is case insensitive
     */
    @JvmName("obpvnxgvyndkvolv")
    public suspend fun azureMonitorWorkspaceName(`value`: Output<String>) {
        this.azureMonitorWorkspaceName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("utqrnawcjojdkpwr")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qptknfxexyqruves")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("cmpbvhnqftgitgay")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the Azure Monitor Workspace. The name is case insensitive
     */
    @JvmName("eivmfpegxuhpsseb")
    public suspend fun azureMonitorWorkspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureMonitorWorkspaceName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("tsxjdqarpsmtieja")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rudvileyxwvuhiak")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xkljlqmheryukrkp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("xhnsmofjfcgvrxsw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AzureMonitorWorkspaceArgs = AzureMonitorWorkspaceArgs(
        azureMonitorWorkspaceName = azureMonitorWorkspaceName,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
