@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.inputs

import com.pulumi.azurenative.monitor.inputs.GetAzureMonitorWorkspacePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property azureMonitorWorkspaceName The name of the Azure Monitor Workspace. The name is case insensitive
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetAzureMonitorWorkspacePlainArgs(
    public val azureMonitorWorkspaceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.monitor.inputs.GetAzureMonitorWorkspacePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.monitor.inputs.GetAzureMonitorWorkspacePlainArgs =
        com.pulumi.azurenative.monitor.inputs.GetAzureMonitorWorkspacePlainArgs.builder()
            .azureMonitorWorkspaceName(azureMonitorWorkspaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAzureMonitorWorkspacePlainArgs].
 */
@PulumiTagMarker
public class GetAzureMonitorWorkspacePlainArgsBuilder internal constructor() {
    private var azureMonitorWorkspaceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Azure Monitor Workspace. The name is case insensitive
     */
    @JvmName("epnwriquaxjxfnwt")
    public suspend fun azureMonitorWorkspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.azureMonitorWorkspaceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rdwmsonrciyixgmk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAzureMonitorWorkspacePlainArgs = GetAzureMonitorWorkspacePlainArgs(
        azureMonitorWorkspaceName = azureMonitorWorkspaceName ?: throw
            PulumiNullFieldException("azureMonitorWorkspaceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
