@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin

import com.pulumi.azurenative.netapp.BackupVaultArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Backup Vault information
 * Azure REST API version: 2022-11-01-preview.
 * Other available API versions: 2023-05-01-preview, 2023-07-01-preview.
 * ## Example Usage
 * ### BackupVault_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var backupVault = new AzureNative.NetApp.BackupVault("backupVault", new()
 *     {
 *         AccountName = "account1",
 *         BackupVaultName = "backupVault1",
 *         Location = "eastus",
 *         ResourceGroupName = "myRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/netapp/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := netapp.NewBackupVault(ctx, "backupVault", &netapp.BackupVaultArgs{
 * 			AccountName:       pulumi.String("account1"),
 * 			BackupVaultName:   pulumi.String("backupVault1"),
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("myRG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.netapp.BackupVault;
 * import com.pulumi.azurenative.netapp.BackupVaultArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var backupVault = new BackupVault("backupVault", BackupVaultArgs.builder()
 *             .accountName("account1")
 *             .backupVaultName("backupVault1")
 *             .location("eastus")
 *             .resourceGroupName("myRG")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:netapp:BackupVault account1/backupVault1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/backupVaults/{backupVaultName}
 * ```
 * @property accountName The name of the NetApp account
 * @property backupVaultName The name of the Backup Vault
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class BackupVaultArgs(
    public val accountName: Output<String>? = null,
    public val backupVaultName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.BackupVaultArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.BackupVaultArgs =
        com.pulumi.azurenative.netapp.BackupVaultArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .backupVaultName(backupVaultName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [BackupVaultArgs].
 */
@PulumiTagMarker
public class BackupVaultArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var backupVaultName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the NetApp account
     */
    @JvmName("lrvcrirynvohtntn")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The name of the Backup Vault
     */
    @JvmName("wktwvbetwywpdsft")
    public suspend fun backupVaultName(`value`: Output<String>) {
        this.backupVaultName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("lfmovoccvqfmueol")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("aqyjapeopniujqov")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("omhwibhflshdcfor")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the NetApp account
     */
    @JvmName("qgurbrejxqruttet")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The name of the Backup Vault
     */
    @JvmName("oroohsctwhvfgvxf")
    public suspend fun backupVaultName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupVaultName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("tahrjxtgirdwrvbh")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("aebqyrcjcxghjkfr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("duasprtkwoehlwrf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("vwcsurwhdkjllssc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): BackupVaultArgs = BackupVaultArgs(
        accountName = accountName,
        backupVaultName = backupVaultName,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
