@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Flag indicating whether subvolume operations are enabled on the volume
 */
public enum class EnableSubvolumes(
    public val javaValue: com.pulumi.azurenative.netapp.enums.EnableSubvolumes,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.enums.EnableSubvolumes> {
    /**
     * subvolumes are enabled
     */
    Enabled(com.pulumi.azurenative.netapp.enums.EnableSubvolumes.Enabled),

    /**
     * subvolumes are not enabled
     */
    Disabled(com.pulumi.azurenative.netapp.enums.EnableSubvolumes.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.netapp.enums.EnableSubvolumes = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.enums.EnableSubvolumes):
            EnableSubvolumes = EnableSubvolumes.values().first { it.javaValue == javaType }
    }
}
