@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.inputs

import com.pulumi.azurenative.netapp.inputs.GetBackupPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the NetApp account
 * @property backupPolicyName Backup policy Name which uniquely identify backup policy.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetBackupPolicyPlainArgs(
    public val accountName: String,
    public val backupPolicyName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.inputs.GetBackupPolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.inputs.GetBackupPolicyPlainArgs =
        com.pulumi.azurenative.netapp.inputs.GetBackupPolicyPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .backupPolicyName(backupPolicyName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBackupPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetBackupPolicyPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var backupPolicyName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the NetApp account
     */
    @JvmName("pvecmfqxlmnrmoqb")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value Backup policy Name which uniquely identify backup policy.
     */
    @JvmName("fwuthgpabgvuslpb")
    public suspend fun backupPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.backupPolicyName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xgsbckjuqglseqrj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetBackupPolicyPlainArgs = GetBackupPolicyPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        backupPolicyName = backupPolicyName ?: throw PulumiNullFieldException("backupPolicyName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
