@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.inputs

import com.pulumi.azurenative.netapp.inputs.GetVolumeGroupIdForLdapUserPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the NetApp account
 * @property poolName The name of the capacity pool
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property username username is required to fetch the group to which user is part of
 * @property volumeName The name of the volume
 */
public data class GetVolumeGroupIdForLdapUserPlainArgs(
    public val accountName: String,
    public val poolName: String,
    public val resourceGroupName: String,
    public val username: String,
    public val volumeName: String,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.inputs.GetVolumeGroupIdForLdapUserPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.inputs.GetVolumeGroupIdForLdapUserPlainArgs =
        com.pulumi.azurenative.netapp.inputs.GetVolumeGroupIdForLdapUserPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .poolName(poolName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .username(username.let({ args0 -> args0 }))
            .volumeName(volumeName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVolumeGroupIdForLdapUserPlainArgs].
 */
@PulumiTagMarker
public class GetVolumeGroupIdForLdapUserPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var poolName: String? = null

    private var resourceGroupName: String? = null

    private var username: String? = null

    private var volumeName: String? = null

    /**
     * @param value The name of the NetApp account
     */
    @JvmName("nqhnuioktngoerio")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the capacity pool
     */
    @JvmName("lowdllaqyjjkdqdy")
    public suspend fun poolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.poolName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("weijxwcartfccghu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value username is required to fetch the group to which user is part of
     */
    @JvmName("pygonslkvkgryelr")
    public suspend fun username(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.username = mapped
    }

    /**
     * @param value The name of the volume
     */
    @JvmName("ujcveidqtlubxaur")
    public suspend fun volumeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.volumeName = mapped
    }

    internal fun build(): GetVolumeGroupIdForLdapUserPlainArgs = GetVolumeGroupIdForLdapUserPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        poolName = poolName ?: throw PulumiNullFieldException("poolName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        username = username ?: throw PulumiNullFieldException("username"),
        volumeName = volumeName ?: throw PulumiNullFieldException("volumeName"),
    )
}
