@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.inputs

import com.pulumi.azurenative.netapp.inputs.GetVolumeGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the NetApp account
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property volumeGroupName The name of the volumeGroup
 */
public data class GetVolumeGroupPlainArgs(
    public val accountName: String,
    public val resourceGroupName: String,
    public val volumeGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.inputs.GetVolumeGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.inputs.GetVolumeGroupPlainArgs =
        com.pulumi.azurenative.netapp.inputs.GetVolumeGroupPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .volumeGroupName(volumeGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVolumeGroupPlainArgs].
 */
@PulumiTagMarker
public class GetVolumeGroupPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var resourceGroupName: String? = null

    private var volumeGroupName: String? = null

    /**
     * @param value The name of the NetApp account
     */
    @JvmName("lmafmyrkuyjrpltu")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qqfquqnegulmcfuk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the volumeGroup
     */
    @JvmName("qteuerqoywwtqufj")
    public suspend fun volumeGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.volumeGroupName = mapped
    }

    internal fun build(): GetVolumeGroupPlainArgs = GetVolumeGroupPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        volumeGroupName = volumeGroupName ?: throw PulumiNullFieldException("volumeGroupName"),
    )
}
