@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * NetApp account resource
 * @property activeDirectories Active Directories
 * @property disableShowmount Shows the status of disableShowmount for all volumes under the subscription, null equals false
 * @property encryption Encryption settings
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity The identity used for the resource.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState Azure lifecycle management
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetAccountResult(
    public val activeDirectories: List<ActiveDirectoryResponse>? = null,
    public val disableShowmount: Boolean,
    public val encryption: AccountEncryptionResponse? = null,
    public val etag: String,
    public val id: String,
    public val identity: ManagedServiceIdentityResponse? = null,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.outputs.GetAccountResult):
            GetAccountResult = GetAccountResult(
            activeDirectories = javaType.activeDirectories().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.netapp.kotlin.outputs.ActiveDirectoryResponse.Companion.toKotlin(args0)
                })
            }),
            disableShowmount = javaType.disableShowmount(),
            encryption = javaType.encryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.netapp.kotlin.outputs.AccountEncryptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.netapp.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.netapp.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
