@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Backup policy information
 * @property backupPolicyId Backup Policy Resource ID
 * @property dailyBackupsToKeep Daily backups count to keep
 * @property enabled The property to decide policy is enabled or not
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property monthlyBackupsToKeep Monthly backups count to keep
 * @property name The name of the resource
 * @property provisioningState Azure lifecycle management
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property volumeBackups A list of volumes assigned to this policy
 * @property volumesAssigned Volumes using current backup policy
 * @property weeklyBackupsToKeep Weekly backups count to keep
 */
public data class GetBackupPolicyResult(
    public val backupPolicyId: String,
    public val dailyBackupsToKeep: Int? = null,
    public val enabled: Boolean? = null,
    public val etag: String,
    public val id: String,
    public val location: String,
    public val monthlyBackupsToKeep: Int? = null,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val volumeBackups: List<VolumeBackupsResponse>,
    public val volumesAssigned: Int,
    public val weeklyBackupsToKeep: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.outputs.GetBackupPolicyResult):
            GetBackupPolicyResult = GetBackupPolicyResult(
            backupPolicyId = javaType.backupPolicyId(),
            dailyBackupsToKeep = javaType.dailyBackupsToKeep().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id(),
            location = javaType.location(),
            monthlyBackupsToKeep = javaType.monthlyBackupsToKeep().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.netapp.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            volumeBackups = javaType.volumeBackups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.netapp.kotlin.outputs.VolumeBackupsResponse.Companion.toKotlin(args0)
                })
            }),
            volumesAssigned = javaType.volumesAssigned(),
            weeklyBackupsToKeep = javaType.weeklyBackupsToKeep().map({ args0 -> args0 }).orElse(null),
        )
    }
}
