@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Replication properties
 * @property endpointType Indicates whether the local volume is the source or destination for the Volume Replication
 * @property remoteVolumeRegion The remote region for the other end of the Volume Replication.
 * @property remoteVolumeResourceId The resource ID of the remote volume.
 * @property replicationId Id
 * @property replicationSchedule Schedule
 */
public data class ReplicationObjectResponse(
    public val endpointType: String? = null,
    public val remoteVolumeRegion: String? = null,
    public val remoteVolumeResourceId: String,
    public val replicationId: String? = null,
    public val replicationSchedule: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.outputs.ReplicationObjectResponse):
            ReplicationObjectResponse = ReplicationObjectResponse(
            endpointType = javaType.endpointType().map({ args0 -> args0 }).orElse(null),
            remoteVolumeRegion = javaType.remoteVolumeRegion().map({ args0 -> args0 }).orElse(null),
            remoteVolumeResourceId = javaType.remoteVolumeResourceId(),
            replicationId = javaType.replicationId().map({ args0 -> args0 }).orElse(null),
            replicationSchedule = javaType.replicationSchedule().map({ args0 -> args0 }).orElse(null),
        )
    }
}
