@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.AdminRuleArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.SecurityConfigurationRuleAccess
import com.pulumi.azurenative.network.kotlin.enums.SecurityConfigurationRuleDirection
import com.pulumi.azurenative.network.kotlin.enums.SecurityConfigurationRuleProtocol
import com.pulumi.azurenative.network.kotlin.inputs.AddressPrefixItemArgs
import com.pulumi.azurenative.network.kotlin.inputs.AddressPrefixItemArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Network admin rule.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2021-02-01-preview, 2021-05-01-preview, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create a default admin rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var adminRule = new AzureNative.Network.AdminRule("adminRule", new()
 *     {
 *         ConfigurationName = "myTestSecurityConfig",
 *         NetworkManagerName = "testNetworkManager",
 *         ResourceGroupName = "rg1",
 *         RuleCollectionName = "testRuleCollection",
 *         RuleName = "SampleDefaultAdminRule",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewAdminRule(ctx, "adminRule", &network.AdminRuleArgs{
 * 			ConfigurationName:  pulumi.String("myTestSecurityConfig"),
 * 			NetworkManagerName: pulumi.String("testNetworkManager"),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			RuleCollectionName: pulumi.String("testRuleCollection"),
 * 			RuleName:           pulumi.String("SampleDefaultAdminRule"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.AdminRule;
 * import com.pulumi.azurenative.network.AdminRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var adminRule = new AdminRule("adminRule", AdminRuleArgs.builder()
 *             .configurationName("myTestSecurityConfig")
 *             .networkManagerName("testNetworkManager")
 *             .resourceGroupName("rg1")
 *             .ruleCollectionName("testRuleCollection")
 *             .ruleName("SampleDefaultAdminRule")
 *             .build());
 *     }
 * }
 * ```
 * ### Create an admin rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var adminRule = new AzureNative.Network.AdminRule("adminRule", new()
 *     {
 *         Access = AzureNative.Network.SecurityConfigurationRuleAccess.Deny,
 *         ConfigurationName = "myTestSecurityConfig",
 *         Description = "This is Sample Admin Rule",
 *         DestinationPortRanges = new[]
 *         {
 *             "22",
 *         },
 *         Destinations = new[]
 *         {
 *             new AzureNative.Network.Inputs.AddressPrefixItemArgs
 *             {
 *                 AddressPrefix = "*",
 *                 AddressPrefixType = AzureNative.Network.AddressPrefixType.IPPrefix,
 *             },
 *         },
 *         Direction = AzureNative.Network.SecurityConfigurationRuleDirection.Inbound,
 *         Kind = "Custom",
 *         NetworkManagerName = "testNetworkManager",
 *         Priority = 1,
 *         Protocol = AzureNative.Network.SecurityConfigurationRuleProtocol.Tcp,
 *         ResourceGroupName = "rg1",
 *         RuleCollectionName = "testRuleCollection",
 *         RuleName = "SampleAdminRule",
 *         SourcePortRanges = new[]
 *         {
 *             "0-65535",
 *         },
 *         Sources = new[]
 *         {
 *             new AzureNative.Network.Inputs.AddressPrefixItemArgs
 *             {
 *                 AddressPrefix = "Internet",
 *                 AddressPrefixType = AzureNative.Network.AddressPrefixType.ServiceTag,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewAdminRule(ctx, "adminRule", &network.AdminRuleArgs{
 * 			Access:            pulumi.String(network.SecurityConfigurationRuleAccessDeny),
 * 			ConfigurationName: pulumi.String("myTestSecurityConfig"),
 * 			Description:       pulumi.String("This is Sample Admin Rule"),
 * 			DestinationPortRanges: pulumi.StringArray{
 * 				pulumi.String("22"),
 * 			},
 * 			Destinations: network.AddressPrefixItemArray{
 * 				&network.AddressPrefixItemArgs{
 * 					AddressPrefix:     pulumi.String("*"),
 * 					AddressPrefixType: pulumi.String(network.AddressPrefixTypeIPPrefix),
 * 				},
 * 			},
 * 			Direction:          pulumi.String(network.SecurityConfigurationRuleDirectionInbound),
 * 			Kind:               pulumi.String("Custom"),
 * 			NetworkManagerName: pulumi.String("testNetworkManager"),
 * 			Priority:           pulumi.Int(1),
 * 			Protocol:           pulumi.String(network.SecurityConfigurationRuleProtocolTcp),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			RuleCollectionName: pulumi.String("testRuleCollection"),
 * 			RuleName:           pulumi.String("SampleAdminRule"),
 * 			SourcePortRanges: pulumi.StringArray{
 * 				pulumi.String("0-65535"),
 * 			},
 * 			Sources: network.AddressPrefixItemArray{
 * 				&network.AddressPrefixItemArgs{
 * 					AddressPrefix:     pulumi.String("Internet"),
 * 					AddressPrefixType: pulumi.String(network.AddressPrefixTypeServiceTag),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.AdminRule;
 * import com.pulumi.azurenative.network.AdminRuleArgs;
 * import com.pulumi.azurenative.network.inputs.AddressPrefixItemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var adminRule = new AdminRule("adminRule", AdminRuleArgs.builder()
 *             .access("Deny")
 *             .configurationName("myTestSecurityConfig")
 *             .description("This is Sample Admin Rule")
 *             .destinationPortRanges("22")
 *             .destinations(AddressPrefixItemArgs.builder()
 *                 .addressPrefix("*")
 *                 .addressPrefixType("IPPrefix")
 *                 .build())
 *             .direction("Inbound")
 *             .kind("Custom")
 *             .networkManagerName("testNetworkManager")
 *             .priority(1)
 *             .protocol("Tcp")
 *             .resourceGroupName("rg1")
 *             .ruleCollectionName("testRuleCollection")
 *             .ruleName("SampleAdminRule")
 *             .sourcePortRanges("0-65535")
 *             .sources(AddressPrefixItemArgs.builder()
 *                 .addressPrefix("Internet")
 *                 .addressPrefixType("ServiceTag")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:AdminRule SampleAdminRule /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/securityAdminConfigurations/{configurationName}/ruleCollections/{ruleCollectionName}/rules/{ruleName}
 * ```
 * @property access Indicates the access allowed for this particular rule
 * @property configurationName The name of the network manager Security Configuration.
 * @property description A description for this rule. Restricted to 140 chars.
 * @property destinationPortRanges The destination port ranges.
 * @property destinations The destination address prefixes. CIDR or destination IP ranges.
 * @property direction Indicates if the traffic matched against the rule in inbound or outbound.
 * @property kind Whether the rule is custom or default.
 * Expected value is 'Custom'.
 * @property networkManagerName The name of the network manager.
 * @property priority The priority of the rule. The value can be between 1 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
 * @property protocol Network protocol this rule applies to.
 * @property resourceGroupName The name of the resource group.
 * @property ruleCollectionName The name of the network manager security Configuration rule collection.
 * @property ruleName The name of the rule.
 * @property sourcePortRanges The source port ranges.
 * @property sources The CIDR or source IP ranges.
 */
public data class AdminRuleArgs(
    public val access: Output<Either<String, SecurityConfigurationRuleAccess>>? = null,
    public val configurationName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val destinationPortRanges: Output<List<String>>? = null,
    public val destinations: Output<List<AddressPrefixItemArgs>>? = null,
    public val direction: Output<Either<String, SecurityConfigurationRuleDirection>>? = null,
    public val kind: Output<String>? = null,
    public val networkManagerName: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val protocol: Output<Either<String, SecurityConfigurationRuleProtocol>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val ruleCollectionName: Output<String>? = null,
    public val ruleName: Output<String>? = null,
    public val sourcePortRanges: Output<List<String>>? = null,
    public val sources: Output<List<AddressPrefixItemArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.AdminRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.network.AdminRuleArgs =
        com.pulumi.azurenative.network.AdminRuleArgs.builder()
            .access(
                access?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .configurationName(configurationName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .destinationPortRanges(destinationPortRanges?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .destinations(
                destinations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .direction(
                direction?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .kind(kind?.applyValue({ args0 -> args0 }))
            .networkManagerName(networkManagerName?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .protocol(
                protocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .ruleCollectionName(ruleCollectionName?.applyValue({ args0 -> args0 }))
            .ruleName(ruleName?.applyValue({ args0 -> args0 }))
            .sourcePortRanges(sourcePortRanges?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sources(
                sources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AdminRuleArgs].
 */
@PulumiTagMarker
public class AdminRuleArgsBuilder internal constructor() {
    private var access: Output<Either<String, SecurityConfigurationRuleAccess>>? = null

    private var configurationName: Output<String>? = null

    private var description: Output<String>? = null

    private var destinationPortRanges: Output<List<String>>? = null

    private var destinations: Output<List<AddressPrefixItemArgs>>? = null

    private var direction: Output<Either<String, SecurityConfigurationRuleDirection>>? = null

    private var kind: Output<String>? = null

    private var networkManagerName: Output<String>? = null

    private var priority: Output<Int>? = null

    private var protocol: Output<Either<String, SecurityConfigurationRuleProtocol>>? = null

    private var resourceGroupName: Output<String>? = null

    private var ruleCollectionName: Output<String>? = null

    private var ruleName: Output<String>? = null

    private var sourcePortRanges: Output<List<String>>? = null

    private var sources: Output<List<AddressPrefixItemArgs>>? = null

    /**
     * @param value Indicates the access allowed for this particular rule
     */
    @JvmName("bixwpakrbupeajgm")
    public suspend fun access(`value`: Output<Either<String, SecurityConfigurationRuleAccess>>) {
        this.access = value
    }

    /**
     * @param value The name of the network manager Security Configuration.
     */
    @JvmName("ximannawffgfduvf")
    public suspend fun configurationName(`value`: Output<String>) {
        this.configurationName = value
    }

    /**
     * @param value A description for this rule. Restricted to 140 chars.
     */
    @JvmName("bdsvwauvcipfitst")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The destination port ranges.
     */
    @JvmName("kalwsiquvkqkoinr")
    public suspend fun destinationPortRanges(`value`: Output<List<String>>) {
        this.destinationPortRanges = value
    }

    @JvmName("nuqyynysqjrgbtja")
    public suspend fun destinationPortRanges(vararg values: Output<String>) {
        this.destinationPortRanges = Output.all(values.asList())
    }

    /**
     * @param values The destination port ranges.
     */
    @JvmName("jeddhpmejebsetkg")
    public suspend fun destinationPortRanges(values: List<Output<String>>) {
        this.destinationPortRanges = Output.all(values)
    }

    /**
     * @param value The destination address prefixes. CIDR or destination IP ranges.
     */
    @JvmName("gijhktsoewdhwnlj")
    public suspend fun destinations(`value`: Output<List<AddressPrefixItemArgs>>) {
        this.destinations = value
    }

    @JvmName("mwldpvoxwwuyekmm")
    public suspend fun destinations(vararg values: Output<AddressPrefixItemArgs>) {
        this.destinations = Output.all(values.asList())
    }

    /**
     * @param values The destination address prefixes. CIDR or destination IP ranges.
     */
    @JvmName("rkpqjiocgyeiqiex")
    public suspend fun destinations(values: List<Output<AddressPrefixItemArgs>>) {
        this.destinations = Output.all(values)
    }

    /**
     * @param value Indicates if the traffic matched against the rule in inbound or outbound.
     */
    @JvmName("yqthsidwdadofnwx")
    public suspend
    fun direction(`value`: Output<Either<String, SecurityConfigurationRuleDirection>>) {
        this.direction = value
    }

    /**
     * @param value Whether the rule is custom or default.
     * Expected value is 'Custom'.
     */
    @JvmName("neaosgfiwsvecwqq")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The name of the network manager.
     */
    @JvmName("dvftghllakyvksvs")
    public suspend fun networkManagerName(`value`: Output<String>) {
        this.networkManagerName = value
    }

    /**
     * @param value The priority of the rule. The value can be between 1 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
     */
    @JvmName("axfcwjdptdschebp")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value Network protocol this rule applies to.
     */
    @JvmName("effyviembxvqebpi")
    public suspend fun protocol(`value`: Output<Either<String, SecurityConfigurationRuleProtocol>>) {
        this.protocol = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("yohfaiuwxvtgwkcc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the network manager security Configuration rule collection.
     */
    @JvmName("qygtwovtavllppwi")
    public suspend fun ruleCollectionName(`value`: Output<String>) {
        this.ruleCollectionName = value
    }

    /**
     * @param value The name of the rule.
     */
    @JvmName("kgyseiyidvmduyrm")
    public suspend fun ruleName(`value`: Output<String>) {
        this.ruleName = value
    }

    /**
     * @param value The source port ranges.
     */
    @JvmName("trgpblvmwomfhsif")
    public suspend fun sourcePortRanges(`value`: Output<List<String>>) {
        this.sourcePortRanges = value
    }

    @JvmName("lgkcdfdsbshtdoem")
    public suspend fun sourcePortRanges(vararg values: Output<String>) {
        this.sourcePortRanges = Output.all(values.asList())
    }

    /**
     * @param values The source port ranges.
     */
    @JvmName("qnjwstbyqwxeinba")
    public suspend fun sourcePortRanges(values: List<Output<String>>) {
        this.sourcePortRanges = Output.all(values)
    }

    /**
     * @param value The CIDR or source IP ranges.
     */
    @JvmName("wgqklmfhgenbvugi")
    public suspend fun sources(`value`: Output<List<AddressPrefixItemArgs>>) {
        this.sources = value
    }

    @JvmName("jhvhpqmtqupuyirj")
    public suspend fun sources(vararg values: Output<AddressPrefixItemArgs>) {
        this.sources = Output.all(values.asList())
    }

    /**
     * @param values The CIDR or source IP ranges.
     */
    @JvmName("ywhsbkjxfjejmmqo")
    public suspend fun sources(values: List<Output<AddressPrefixItemArgs>>) {
        this.sources = Output.all(values)
    }

    /**
     * @param value Indicates the access allowed for this particular rule
     */
    @JvmName("rjvkrpenmqpbltww")
    public suspend fun access(`value`: Either<String, SecurityConfigurationRuleAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.access = mapped
    }

    /**
     * @param value Indicates the access allowed for this particular rule
     */
    @JvmName("uybegsihndoxkkdh")
    public fun access(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SecurityConfigurationRuleAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.access = mapped
    }

    /**
     * @param value Indicates the access allowed for this particular rule
     */
    @JvmName("ehkljaawbutxjtey")
    public fun access(`value`: SecurityConfigurationRuleAccess) {
        val toBeMapped = Either.ofRight<String, SecurityConfigurationRuleAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.access = mapped
    }

    /**
     * @param value The name of the network manager Security Configuration.
     */
    @JvmName("tsyqiajdsexlrftt")
    public suspend fun configurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationName = mapped
    }

    /**
     * @param value A description for this rule. Restricted to 140 chars.
     */
    @JvmName("tbeacerjwjbacjwf")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The destination port ranges.
     */
    @JvmName("udetbpnwrtjqxcwc")
    public suspend fun destinationPortRanges(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPortRanges = mapped
    }

    /**
     * @param values The destination port ranges.
     */
    @JvmName("djhwxiafiwvjxndy")
    public suspend fun destinationPortRanges(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationPortRanges = mapped
    }

    /**
     * @param value The destination address prefixes. CIDR or destination IP ranges.
     */
    @JvmName("uhjkpmngtacrmdwa")
    public suspend fun destinations(`value`: List<AddressPrefixItemArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinations = mapped
    }

    /**
     * @param argument The destination address prefixes. CIDR or destination IP ranges.
     */
    @JvmName("wiwprccmigfnotqy")
    public suspend fun destinations(argument: List<suspend AddressPrefixItemArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AddressPrefixItemArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.destinations = mapped
    }

    /**
     * @param argument The destination address prefixes. CIDR or destination IP ranges.
     */
    @JvmName("mghpvgidqcemiwbc")
    public suspend fun destinations(
        vararg
        argument: suspend AddressPrefixItemArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AddressPrefixItemArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.destinations = mapped
    }

    /**
     * @param argument The destination address prefixes. CIDR or destination IP ranges.
     */
    @JvmName("xqxjmwyintwjconc")
    public suspend fun destinations(argument: suspend AddressPrefixItemArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AddressPrefixItemArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.destinations = mapped
    }

    /**
     * @param values The destination address prefixes. CIDR or destination IP ranges.
     */
    @JvmName("hygftxxcukhhmbtu")
    public suspend fun destinations(vararg values: AddressPrefixItemArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinations = mapped
    }

    /**
     * @param value Indicates if the traffic matched against the rule in inbound or outbound.
     */
    @JvmName("aqtsnadtfcbagqyo")
    public suspend fun direction(`value`: Either<String, SecurityConfigurationRuleDirection>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value Indicates if the traffic matched against the rule in inbound or outbound.
     */
    @JvmName("lxsgekborysdjbgt")
    public fun direction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SecurityConfigurationRuleDirection>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value Indicates if the traffic matched against the rule in inbound or outbound.
     */
    @JvmName("vhxxnfvqwbynchri")
    public fun direction(`value`: SecurityConfigurationRuleDirection) {
        val toBeMapped = Either.ofRight<String, SecurityConfigurationRuleDirection>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value Whether the rule is custom or default.
     * Expected value is 'Custom'.
     */
    @JvmName("nadmahdilpaojbfx")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The name of the network manager.
     */
    @JvmName("xyirurdhyewddgfo")
    public suspend fun networkManagerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkManagerName = mapped
    }

    /**
     * @param value The priority of the rule. The value can be between 1 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
     */
    @JvmName("vpgiboioferwjrcf")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value Network protocol this rule applies to.
     */
    @JvmName("wcgvotxoogekuhgf")
    public suspend fun protocol(`value`: Either<String, SecurityConfigurationRuleProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Network protocol this rule applies to.
     */
    @JvmName("xbriagcmgaaetoji")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SecurityConfigurationRuleProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Network protocol this rule applies to.
     */
    @JvmName("asafahlxvpimkcwf")
    public fun protocol(`value`: SecurityConfigurationRuleProtocol) {
        val toBeMapped = Either.ofRight<String, SecurityConfigurationRuleProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ggvtrftdqsjofsqd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the network manager security Configuration rule collection.
     */
    @JvmName("nrvfawkwnbencnkm")
    public suspend fun ruleCollectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleCollectionName = mapped
    }

    /**
     * @param value The name of the rule.
     */
    @JvmName("iyqbesvrpxuexcyy")
    public suspend fun ruleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleName = mapped
    }

    /**
     * @param value The source port ranges.
     */
    @JvmName("drkrtllwpadiajsm")
    public suspend fun sourcePortRanges(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourcePortRanges = mapped
    }

    /**
     * @param values The source port ranges.
     */
    @JvmName("miyxhfudurejqere")
    public suspend fun sourcePortRanges(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourcePortRanges = mapped
    }

    /**
     * @param value The CIDR or source IP ranges.
     */
    @JvmName("hnitynvgilprljae")
    public suspend fun sources(`value`: List<AddressPrefixItemArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param argument The CIDR or source IP ranges.
     */
    @JvmName("uyjaujhfyktmixdx")
    public suspend fun sources(argument: List<suspend AddressPrefixItemArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AddressPrefixItemArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument The CIDR or source IP ranges.
     */
    @JvmName("epsdjssimujfbalp")
    public suspend fun sources(vararg argument: suspend AddressPrefixItemArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AddressPrefixItemArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument The CIDR or source IP ranges.
     */
    @JvmName("xjqpxprpggypptda")
    public suspend fun sources(argument: suspend AddressPrefixItemArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AddressPrefixItemArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param values The CIDR or source IP ranges.
     */
    @JvmName("fqnlywotpdxclgci")
    public suspend fun sources(vararg values: AddressPrefixItemArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    internal fun build(): AdminRuleArgs = AdminRuleArgs(
        access = access,
        configurationName = configurationName,
        description = description,
        destinationPortRanges = destinationPortRanges,
        destinations = destinations,
        direction = direction,
        kind = kind,
        networkManagerName = networkManagerName,
        priority = priority,
        protocol = protocol,
        resourceGroupName = resourceGroupName,
        ruleCollectionName = ruleCollectionName,
        ruleName = ruleName,
        sourcePortRanges = sourcePortRanges,
        sources = sources,
    )
}
