@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.AdminRuleCollectionArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.NetworkManagerSecurityGroupItemArgs
import com.pulumi.azurenative.network.kotlin.inputs.NetworkManagerSecurityGroupItemArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines the admin rule collection.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2021-02-01-preview, 2021-05-01-preview, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create or Update an admin rule collection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var adminRuleCollection = new AzureNative.Network.AdminRuleCollection("adminRuleCollection", new()
 *     {
 *         AppliesToGroups = new[]
 *         {
 *             new AzureNative.Network.Inputs.NetworkManagerSecurityGroupItemArgs
 *             {
 *                 NetworkGroupId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Network/networkManagers/testNetworkManager/networkGroups/testGroup",
 *             },
 *         },
 *         ConfigurationName = "myTestSecurityConfig",
 *         Description = "A sample policy",
 *         NetworkManagerName = "testNetworkManager",
 *         ResourceGroupName = "rg1",
 *         RuleCollectionName = "testRuleCollection",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewAdminRuleCollection(ctx, "adminRuleCollection", &network.AdminRuleCollectionArgs{
 * 			AppliesToGroups: network.NetworkManagerSecurityGroupItemArray{
 * 				&network.NetworkManagerSecurityGroupItemArgs{
 * 					NetworkGroupId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Network/networkManagers/testNetworkManager/networkGroups/testGroup"),
 * 				},
 * 			},
 * 			ConfigurationName:  pulumi.String("myTestSecurityConfig"),
 * 			Description:        pulumi.String("A sample policy"),
 * 			NetworkManagerName: pulumi.String("testNetworkManager"),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			RuleCollectionName: pulumi.String("testRuleCollection"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.AdminRuleCollection;
 * import com.pulumi.azurenative.network.AdminRuleCollectionArgs;
 * import com.pulumi.azurenative.network.inputs.NetworkManagerSecurityGroupItemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var adminRuleCollection = new AdminRuleCollection("adminRuleCollection", AdminRuleCollectionArgs.builder()
 *             .appliesToGroups(NetworkManagerSecurityGroupItemArgs.builder()
 *                 .networkGroupId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Network/networkManagers/testNetworkManager/networkGroups/testGroup")
 *                 .build())
 *             .configurationName("myTestSecurityConfig")
 *             .description("A sample policy")
 *             .networkManagerName("testNetworkManager")
 *             .resourceGroupName("rg1")
 *             .ruleCollectionName("testRuleCollection")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:AdminRuleCollection myTestSecurityConfig /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/securityAdminConfigurations/{configurationName}/ruleCollections/{ruleCollectionName}
 * ```
 * @property appliesToGroups Groups for configuration
 * @property configurationName The name of the network manager Security Configuration.
 * @property description A description of the admin rule collection.
 * @property networkManagerName The name of the network manager.
 * @property resourceGroupName The name of the resource group.
 * @property ruleCollectionName The name of the network manager security Configuration rule collection.
 */
public data class AdminRuleCollectionArgs(
    public val appliesToGroups: Output<List<NetworkManagerSecurityGroupItemArgs>>? = null,
    public val configurationName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val networkManagerName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val ruleCollectionName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.AdminRuleCollectionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.AdminRuleCollectionArgs =
        com.pulumi.azurenative.network.AdminRuleCollectionArgs.builder()
            .appliesToGroups(
                appliesToGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .configurationName(configurationName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .networkManagerName(networkManagerName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .ruleCollectionName(ruleCollectionName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AdminRuleCollectionArgs].
 */
@PulumiTagMarker
public class AdminRuleCollectionArgsBuilder internal constructor() {
    private var appliesToGroups: Output<List<NetworkManagerSecurityGroupItemArgs>>? = null

    private var configurationName: Output<String>? = null

    private var description: Output<String>? = null

    private var networkManagerName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var ruleCollectionName: Output<String>? = null

    /**
     * @param value Groups for configuration
     */
    @JvmName("ohrrpgeeudtjrtyg")
    public suspend fun appliesToGroups(`value`: Output<List<NetworkManagerSecurityGroupItemArgs>>) {
        this.appliesToGroups = value
    }

    @JvmName("aqjwvdsgcnisshkm")
    public suspend fun appliesToGroups(vararg values: Output<NetworkManagerSecurityGroupItemArgs>) {
        this.appliesToGroups = Output.all(values.asList())
    }

    /**
     * @param values Groups for configuration
     */
    @JvmName("thpnghvvovhkdnsw")
    public suspend fun appliesToGroups(values: List<Output<NetworkManagerSecurityGroupItemArgs>>) {
        this.appliesToGroups = Output.all(values)
    }

    /**
     * @param value The name of the network manager Security Configuration.
     */
    @JvmName("uyjpxgptbfgqisxa")
    public suspend fun configurationName(`value`: Output<String>) {
        this.configurationName = value
    }

    /**
     * @param value A description of the admin rule collection.
     */
    @JvmName("peupcxytsuoegcfx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the network manager.
     */
    @JvmName("vnpqlpdvqeeenykw")
    public suspend fun networkManagerName(`value`: Output<String>) {
        this.networkManagerName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("gdpupryaafilepda")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the network manager security Configuration rule collection.
     */
    @JvmName("rikioqumgmikftxk")
    public suspend fun ruleCollectionName(`value`: Output<String>) {
        this.ruleCollectionName = value
    }

    /**
     * @param value Groups for configuration
     */
    @JvmName("wvfsurpvghlsnjwu")
    public suspend fun appliesToGroups(`value`: List<NetworkManagerSecurityGroupItemArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appliesToGroups = mapped
    }

    /**
     * @param argument Groups for configuration
     */
    @JvmName("qlfruindjunbopel")
    public suspend
    fun appliesToGroups(argument: List<suspend NetworkManagerSecurityGroupItemArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NetworkManagerSecurityGroupItemArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.appliesToGroups = mapped
    }

    /**
     * @param argument Groups for configuration
     */
    @JvmName("yjtkltmdyydgrddk")
    public suspend fun appliesToGroups(
        vararg
        argument: suspend NetworkManagerSecurityGroupItemArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            NetworkManagerSecurityGroupItemArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.appliesToGroups = mapped
    }

    /**
     * @param argument Groups for configuration
     */
    @JvmName("ryjlekfuamfccnru")
    public suspend
    fun appliesToGroups(argument: suspend NetworkManagerSecurityGroupItemArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            NetworkManagerSecurityGroupItemArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.appliesToGroups = mapped
    }

    /**
     * @param values Groups for configuration
     */
    @JvmName("mcruywslnffqbsxk")
    public suspend fun appliesToGroups(vararg values: NetworkManagerSecurityGroupItemArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.appliesToGroups = mapped
    }

    /**
     * @param value The name of the network manager Security Configuration.
     */
    @JvmName("mvbljkfsyyxcdxny")
    public suspend fun configurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationName = mapped
    }

    /**
     * @param value A description of the admin rule collection.
     */
    @JvmName("yaajbjrmjrmbueqh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the network manager.
     */
    @JvmName("gjuwptjwpkmbqxoo")
    public suspend fun networkManagerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkManagerName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("axnvugrusrmhvpqg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the network manager security Configuration rule collection.
     */
    @JvmName("yicwdhicokicuuat")
    public suspend fun ruleCollectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleCollectionName = mapped
    }

    internal fun build(): AdminRuleCollectionArgs = AdminRuleCollectionArgs(
        appliesToGroups = appliesToGroups,
        configurationName = configurationName,
        description = description,
        networkManagerName = networkManagerName,
        resourceGroupName = resourceGroupName,
        ruleCollectionName = ruleCollectionName,
    )
}
