@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayAuthenticationCertificateResponse
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayAutoscaleConfigurationResponse
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayBackendAddressPoolResponse
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayBackendHttpSettingsResponse
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayBackendSettingsResponse
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayCustomErrorResponse
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayFrontendIPConfigurationResponse
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayFrontendPortResponse
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayGlobalConfigurationResponse
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayHttpListenerResponse
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayIPConfigurationResponse
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayListenerResponse
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayLoadDistributionPolicyResponse
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayPrivateEndpointConnectionResponse
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayPrivateLinkConfigurationResponse
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayProbeResponse
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayRedirectConfigurationResponse
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayRequestRoutingRuleResponse
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayRewriteRuleSetResponse
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayRoutingRuleResponse
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewaySkuResponse
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewaySslCertificateResponse
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewaySslPolicyResponse
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewaySslProfileResponse
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayTrustedClientCertificateResponse
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayTrustedRootCertificateResponse
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayUrlPathMapResponse
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayWebApplicationFirewallConfigurationResponse
import com.pulumi.azurenative.network.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayAuthenticationCertificateResponse.Companion.toKotlin as applicationGatewayAuthenticationCertificateResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayAutoscaleConfigurationResponse.Companion.toKotlin as applicationGatewayAutoscaleConfigurationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayBackendAddressPoolResponse.Companion.toKotlin as applicationGatewayBackendAddressPoolResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayBackendHttpSettingsResponse.Companion.toKotlin as applicationGatewayBackendHttpSettingsResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayBackendSettingsResponse.Companion.toKotlin as applicationGatewayBackendSettingsResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayCustomErrorResponse.Companion.toKotlin as applicationGatewayCustomErrorResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayFrontendIPConfigurationResponse.Companion.toKotlin as applicationGatewayFrontendIPConfigurationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayFrontendPortResponse.Companion.toKotlin as applicationGatewayFrontendPortResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayGlobalConfigurationResponse.Companion.toKotlin as applicationGatewayGlobalConfigurationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayHttpListenerResponse.Companion.toKotlin as applicationGatewayHttpListenerResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayIPConfigurationResponse.Companion.toKotlin as applicationGatewayIPConfigurationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayListenerResponse.Companion.toKotlin as applicationGatewayListenerResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayLoadDistributionPolicyResponse.Companion.toKotlin as applicationGatewayLoadDistributionPolicyResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayPrivateEndpointConnectionResponse.Companion.toKotlin as applicationGatewayPrivateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayPrivateLinkConfigurationResponse.Companion.toKotlin as applicationGatewayPrivateLinkConfigurationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayProbeResponse.Companion.toKotlin as applicationGatewayProbeResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayRedirectConfigurationResponse.Companion.toKotlin as applicationGatewayRedirectConfigurationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayRequestRoutingRuleResponse.Companion.toKotlin as applicationGatewayRequestRoutingRuleResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayRewriteRuleSetResponse.Companion.toKotlin as applicationGatewayRewriteRuleSetResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayRoutingRuleResponse.Companion.toKotlin as applicationGatewayRoutingRuleResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewaySkuResponse.Companion.toKotlin as applicationGatewaySkuResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewaySslCertificateResponse.Companion.toKotlin as applicationGatewaySslCertificateResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewaySslPolicyResponse.Companion.toKotlin as applicationGatewaySslPolicyResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewaySslProfileResponse.Companion.toKotlin as applicationGatewaySslProfileResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayTrustedClientCertificateResponse.Companion.toKotlin as applicationGatewayTrustedClientCertificateResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayTrustedRootCertificateResponse.Companion.toKotlin as applicationGatewayTrustedRootCertificateResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayUrlPathMapResponse.Companion.toKotlin as applicationGatewayUrlPathMapResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayWebApplicationFirewallConfigurationResponse.Companion.toKotlin as applicationGatewayWebApplicationFirewallConfigurationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin

/**
 * Builder for [ApplicationGateway].
 */
@PulumiTagMarker
public class ApplicationGatewayResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplicationGatewayArgs = ApplicationGatewayArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApplicationGatewayArgsBuilder.() -> Unit) {
        val builder = ApplicationGatewayArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ApplicationGateway {
        val builtJavaResource =
            com.pulumi.azurenative.network.ApplicationGateway(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ApplicationGateway(builtJavaResource)
    }
}

/**
 * Application gateway resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2015-05-01-preview, 2019-06-01, 2019-08-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:ApplicationGateway appgw /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}
 * ```
 */
public class ApplicationGateway internal constructor(
    override val javaResource: com.pulumi.azurenative.network.ApplicationGateway,
) : KotlinCustomResource(javaResource, ApplicationGatewayMapper) {
    /**
     * Authentication certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    public val authenticationCertificates:
        Output<List<ApplicationGatewayAuthenticationCertificateResponse>>?
        get() = javaResource.authenticationCertificates().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        applicationGatewayAuthenticationCertificateResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Autoscale Configuration.
     */
    public val autoscaleConfiguration: Output<ApplicationGatewayAutoscaleConfigurationResponse>?
        get() = javaResource.autoscaleConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    applicationGatewayAutoscaleConfigurationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Backend address pool of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    public val backendAddressPools: Output<List<ApplicationGatewayBackendAddressPoolResponse>>?
        get() = javaResource.backendAddressPools().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        applicationGatewayBackendAddressPoolResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Backend http settings of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    public val backendHttpSettingsCollection:
        Output<List<ApplicationGatewayBackendHttpSettingsResponse>>?
        get() = javaResource.backendHttpSettingsCollection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        applicationGatewayBackendHttpSettingsResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Backend settings of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    public val backendSettingsCollection: Output<List<ApplicationGatewayBackendSettingsResponse>>?
        get() = javaResource.backendSettingsCollection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        applicationGatewayBackendSettingsResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Custom error configurations of the application gateway resource.
     */
    public val customErrorConfigurations: Output<List<ApplicationGatewayCustomErrorResponse>>?
        get() = javaResource.customErrorConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        applicationGatewayCustomErrorResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The default predefined SSL Policy applied on the application gateway resource.
     */
    public val defaultPredefinedSslPolicy: Output<String>
        get() = javaResource.defaultPredefinedSslPolicy().applyValue({ args0 -> args0 })

    /**
     * Whether FIPS is enabled on the application gateway resource.
     */
    public val enableFips: Output<Boolean>?
        get() = javaResource.enableFips().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether HTTP2 is enabled on the application gateway resource.
     */
    public val enableHttp2: Output<Boolean>?
        get() = javaResource.enableHttp2().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Reference to the FirewallPolicy resource.
     */
    public val firewallPolicy: Output<SubResourceResponse>?
        get() = javaResource.firewallPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * If true, associates a firewall policy with an application gateway regardless whether the policy differs from the WAF Config.
     */
    public val forceFirewallPolicyAssociation: Output<Boolean>?
        get() = javaResource.forceFirewallPolicyAssociation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Frontend IP addresses of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    public val frontendIPConfigurations:
        Output<List<ApplicationGatewayFrontendIPConfigurationResponse>>?
        get() = javaResource.frontendIPConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        applicationGatewayFrontendIPConfigurationResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Frontend ports of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    public val frontendPorts: Output<List<ApplicationGatewayFrontendPortResponse>>?
        get() = javaResource.frontendPorts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        applicationGatewayFrontendPortResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Subnets of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    public val gatewayIPConfigurations: Output<List<ApplicationGatewayIPConfigurationResponse>>?
        get() = javaResource.gatewayIPConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        applicationGatewayIPConfigurationResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Global Configuration.
     */
    public val globalConfiguration: Output<ApplicationGatewayGlobalConfigurationResponse>?
        get() = javaResource.globalConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    applicationGatewayGlobalConfigurationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Http listeners of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    public val httpListeners: Output<List<ApplicationGatewayHttpListenerResponse>>?
        get() = javaResource.httpListeners().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        applicationGatewayHttpListenerResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The identity of the application gateway, if configured.
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Listeners of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    public val listeners: Output<List<ApplicationGatewayListenerResponse>>?
        get() = javaResource.listeners().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> applicationGatewayListenerResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Load distribution policies of the application gateway resource.
     */
    public val loadDistributionPolicies:
        Output<List<ApplicationGatewayLoadDistributionPolicyResponse>>?
        get() = javaResource.loadDistributionPolicies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        applicationGatewayLoadDistributionPolicyResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Operational state of the application gateway resource.
     */
    public val operationalState: Output<String>
        get() = javaResource.operationalState().applyValue({ args0 -> args0 })

    /**
     * Private Endpoint connections on application gateway.
     */
    public val privateEndpointConnections:
        Output<List<ApplicationGatewayPrivateEndpointConnectionResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> applicationGatewayPrivateEndpointConnectionResponseToKotlin(args0) })
            })
        })

    /**
     * PrivateLink configurations on application gateway.
     */
    public val privateLinkConfigurations:
        Output<List<ApplicationGatewayPrivateLinkConfigurationResponse>>?
        get() = javaResource.privateLinkConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        applicationGatewayPrivateLinkConfigurationResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Probes of the application gateway resource.
     */
    public val probes: Output<List<ApplicationGatewayProbeResponse>>?
        get() = javaResource.probes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> applicationGatewayProbeResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The provisioning state of the application gateway resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Redirect configurations of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    public val redirectConfigurations: Output<List<ApplicationGatewayRedirectConfigurationResponse>>?
        get() = javaResource.redirectConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        applicationGatewayRedirectConfigurationResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Request routing rules of the application gateway resource.
     */
    public val requestRoutingRules: Output<List<ApplicationGatewayRequestRoutingRuleResponse>>?
        get() = javaResource.requestRoutingRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        applicationGatewayRequestRoutingRuleResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The resource GUID property of the application gateway resource.
     */
    public val resourceGuid: Output<String>
        get() = javaResource.resourceGuid().applyValue({ args0 -> args0 })

    /**
     * Rewrite rules for the application gateway resource.
     */
    public val rewriteRuleSets: Output<List<ApplicationGatewayRewriteRuleSetResponse>>?
        get() = javaResource.rewriteRuleSets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        applicationGatewayRewriteRuleSetResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Routing rules of the application gateway resource.
     */
    public val routingRules: Output<List<ApplicationGatewayRoutingRuleResponse>>?
        get() = javaResource.routingRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        applicationGatewayRoutingRuleResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * SKU of the application gateway resource.
     */
    public val sku: Output<ApplicationGatewaySkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    applicationGatewaySkuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * SSL certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    public val sslCertificates: Output<List<ApplicationGatewaySslCertificateResponse>>?
        get() = javaResource.sslCertificates().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        applicationGatewaySslCertificateResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * SSL policy of the application gateway resource.
     */
    public val sslPolicy: Output<ApplicationGatewaySslPolicyResponse>?
        get() = javaResource.sslPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    applicationGatewaySslPolicyResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * SSL profiles of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    public val sslProfiles: Output<List<ApplicationGatewaySslProfileResponse>>?
        get() = javaResource.sslProfiles().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> applicationGatewaySslProfileResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Trusted client certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    public val trustedClientCertificates:
        Output<List<ApplicationGatewayTrustedClientCertificateResponse>>?
        get() = javaResource.trustedClientCertificates().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        applicationGatewayTrustedClientCertificateResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Trusted Root certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    public val trustedRootCertificates:
        Output<List<ApplicationGatewayTrustedRootCertificateResponse>>?
        get() = javaResource.trustedRootCertificates().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        applicationGatewayTrustedRootCertificateResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * URL path map of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
     */
    public val urlPathMaps: Output<List<ApplicationGatewayUrlPathMapResponse>>?
        get() = javaResource.urlPathMaps().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> applicationGatewayUrlPathMapResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Web application firewall configuration.
     */
    public val webApplicationFirewallConfiguration:
        Output<ApplicationGatewayWebApplicationFirewallConfigurationResponse>?
        get() = javaResource.webApplicationFirewallConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    applicationGatewayWebApplicationFirewallConfigurationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * A list of availability zones denoting where the resource needs to come from.
     */
    public val zones: Output<List<String>>?
        get() = javaResource.zones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object ApplicationGatewayMapper : ResourceMapper<ApplicationGateway> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.ApplicationGateway::class == javaResource::class

    override fun map(javaResource: Resource): ApplicationGateway = ApplicationGateway(
        javaResource as
            com.pulumi.azurenative.network.ApplicationGateway,
    )
}

/**
 * @see [ApplicationGateway].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApplicationGateway].
 */
public suspend fun applicationGateway(
    name: String,
    block: suspend ApplicationGatewayResourceBuilder.() -> Unit,
): ApplicationGateway {
    val builder = ApplicationGatewayResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApplicationGateway].
 * @param name The _unique_ name of the resulting resource.
 */
public fun applicationGateway(name: String): ApplicationGateway {
    val builder = ApplicationGatewayResourceBuilder()
    builder.name(name)
    return builder.build()
}
