@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.PrivateEndpointResponse
import com.pulumi.azurenative.network.kotlin.outputs.PrivateLinkServiceConnectionStateResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.network.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin as privateEndpointResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin as privateLinkServiceConnectionStateResponseToKotlin

/**
 * Builder for [ApplicationGatewayPrivateEndpointConnection].
 */
@PulumiTagMarker
public class ApplicationGatewayPrivateEndpointConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplicationGatewayPrivateEndpointConnectionArgs =
        ApplicationGatewayPrivateEndpointConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend ApplicationGatewayPrivateEndpointConnectionArgsBuilder.() -> Unit) {
        val builder = ApplicationGatewayPrivateEndpointConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ApplicationGatewayPrivateEndpointConnection {
        val builtJavaResource =
            com.pulumi.azurenative.network.ApplicationGatewayPrivateEndpointConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ApplicationGatewayPrivateEndpointConnection(builtJavaResource)
    }
}

/**
 * Private Endpoint connection on an application gateway.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Update Application Gateway Private Endpoint Connection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var applicationGatewayPrivateEndpointConnection = new AzureNative.Network.ApplicationGatewayPrivateEndpointConnection("applicationGatewayPrivateEndpointConnection", new()
 *     {
 *         ApplicationGatewayName = "appgw",
 *         ConnectionName = "connection1",
 *         Name = "connection1",
 *         PrivateLinkServiceConnectionState = new AzureNative.Network.Inputs.PrivateLinkServiceConnectionStateArgs
 *         {
 *             Description = "approved it for some reason.",
 *             Status = "Approved",
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewApplicationGatewayPrivateEndpointConnection(ctx, "applicationGatewayPrivateEndpointConnection", &network.ApplicationGatewayPrivateEndpointConnectionArgs{
 * 			ApplicationGatewayName: pulumi.String("appgw"),
 * 			ConnectionName:         pulumi.String("connection1"),
 * 			Name:                   pulumi.String("connection1"),
 * 			PrivateLinkServiceConnectionState: &network.PrivateLinkServiceConnectionStateArgs{
 * 				Description: pulumi.String("approved it for some reason."),
 * 				Status:      pulumi.String("Approved"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ApplicationGatewayPrivateEndpointConnection;
 * import com.pulumi.azurenative.network.ApplicationGatewayPrivateEndpointConnectionArgs;
 * import com.pulumi.azurenative.network.inputs.PrivateLinkServiceConnectionStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var applicationGatewayPrivateEndpointConnection = new ApplicationGatewayPrivateEndpointConnection("applicationGatewayPrivateEndpointConnection", ApplicationGatewayPrivateEndpointConnectionArgs.builder()
 *             .applicationGatewayName("appgw")
 *             .connectionName("connection1")
 *             .name("connection1")
 *             .privateLinkServiceConnectionState(PrivateLinkServiceConnectionStateArgs.builder()
 *                 .description("approved it for some reason.")
 *                 .status("Approved")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:ApplicationGatewayPrivateEndpointConnection testPlePeConnection /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}/privateEndpointConnections/{connectionName}
 * ```
 */
public class ApplicationGatewayPrivateEndpointConnection internal constructor(
    override val javaResource:
    com.pulumi.azurenative.network.ApplicationGatewayPrivateEndpointConnection,
) : KotlinCustomResource(javaResource, ApplicationGatewayPrivateEndpointConnectionMapper) {
    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The consumer link id.
     */
    public val linkIdentifier: Output<String>
        get() = javaResource.linkIdentifier().applyValue({ args0 -> args0 })

    /**
     * Name of the private endpoint connection on an application gateway.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The resource of private end point.
     */
    public val privateEndpoint: Output<PrivateEndpointResponse>
        get() = javaResource.privateEndpoint().applyValue({ args0 ->
            args0.let({ args0 ->
                privateEndpointResponseToKotlin(args0)
            })
        })

    /**
     * A collection of information about the state of the connection between service consumer and provider.
     */
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateResponse>?
        get() = javaResource.privateLinkServiceConnectionState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    privateLinkServiceConnectionStateResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The provisioning state of the application gateway private endpoint connection resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ApplicationGatewayPrivateEndpointConnectionMapper :
    ResourceMapper<ApplicationGatewayPrivateEndpointConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.ApplicationGatewayPrivateEndpointConnection::class == javaResource::class

    override fun map(javaResource: Resource): ApplicationGatewayPrivateEndpointConnection =
        ApplicationGatewayPrivateEndpointConnection(
            javaResource as
                com.pulumi.azurenative.network.ApplicationGatewayPrivateEndpointConnection,
        )
}

/**
 * @see [ApplicationGatewayPrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApplicationGatewayPrivateEndpointConnection].
 */
public suspend fun applicationGatewayPrivateEndpointConnection(
    name: String,
    block: suspend ApplicationGatewayPrivateEndpointConnectionResourceBuilder.() -> Unit,
):
    ApplicationGatewayPrivateEndpointConnection {
    val builder = ApplicationGatewayPrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApplicationGatewayPrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun applicationGatewayPrivateEndpointConnection(name: String):
    ApplicationGatewayPrivateEndpointConnection {
    val builder = ApplicationGatewayPrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
