@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.BastionHostIPConfigurationResponse
import com.pulumi.azurenative.network.kotlin.outputs.SkuResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.BastionHostIPConfigurationResponse.Companion.toKotlin as bastionHostIPConfigurationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin

/**
 * Builder for [BastionHost].
 */
@PulumiTagMarker
public class BastionHostResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BastionHostArgs = BastionHostArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BastionHostArgsBuilder.() -> Unit) {
        val builder = BastionHostArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BastionHost {
        val builtJavaResource = com.pulumi.azurenative.network.BastionHost(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BastionHost(builtJavaResource)
    }
}

/**
 * Bastion Host resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create Bastion Host
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var bastionHost = new AzureNative.Network.BastionHost("bastionHost", new()
 *     {
 *         BastionHostName = "bastionhosttenant",
 *         IpConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.BastionHostIPConfigurationArgs
 *             {
 *                 Name = "bastionHostIpConfiguration",
 *                 PublicIPAddress = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName",
 *                 },
 *                 Subnet = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/BastionHostSubnet",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewBastionHost(ctx, "bastionHost", &network.BastionHostArgs{
 * 			BastionHostName: pulumi.String("bastionhosttenant"),
 * 			IpConfigurations: network.BastionHostIPConfigurationArray{
 * 				&network.BastionHostIPConfigurationArgs{
 * 					Name: pulumi.String("bastionHostIpConfiguration"),
 * 					PublicIPAddress: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName"),
 * 					},
 * 					Subnet: &network.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/BastionHostSubnet"),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.BastionHost;
 * import com.pulumi.azurenative.network.BastionHostArgs;
 * import com.pulumi.azurenative.network.inputs.BastionHostIPConfigurationArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bastionHost = new BastionHost("bastionHost", BastionHostArgs.builder()
 *             .bastionHostName("bastionhosttenant")
 *             .ipConfigurations(BastionHostIPConfigurationArgs.builder()
 *                 .name("bastionHostIpConfiguration")
 *                 .publicIPAddress(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName")
 *                     .build())
 *                 .subnet(SubResourceArgs.builder()
 *                     .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/BastionHostSubnet")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:BastionHost bastionhost /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/bastionHosts/{bastionHostName}
 * ```
 */
public class BastionHost internal constructor(
    override val javaResource: com.pulumi.azurenative.network.BastionHost,
) : KotlinCustomResource(javaResource, BastionHostMapper) {
    /**
     * Enable/Disable Copy/Paste feature of the Bastion Host resource.
     */
    public val disableCopyPaste: Output<Boolean>?
        get() = javaResource.disableCopyPaste().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * FQDN for the endpoint on which bastion host is accessible.
     */
    public val dnsName: Output<String>?
        get() = javaResource.dnsName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Enable/Disable File Copy feature of the Bastion Host resource.
     */
    public val enableFileCopy: Output<Boolean>?
        get() = javaResource.enableFileCopy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable/Disable IP Connect feature of the Bastion Host resource.
     */
    public val enableIpConnect: Output<Boolean>?
        get() = javaResource.enableIpConnect().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable/Disable Kerberos feature of the Bastion Host resource.
     */
    public val enableKerberos: Output<Boolean>?
        get() = javaResource.enableKerberos().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable/Disable Shareable Link of the Bastion Host resource.
     */
    public val enableShareableLink: Output<Boolean>?
        get() = javaResource.enableShareableLink().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable/Disable Tunneling feature of the Bastion Host resource.
     */
    public val enableTunneling: Output<Boolean>?
        get() = javaResource.enableTunneling().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * IP configuration of the Bastion Host resource.
     */
    public val ipConfigurations: Output<List<BastionHostIPConfigurationResponse>>?
        get() = javaResource.ipConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        bastionHostIPConfigurationResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the bastion host resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The scale units for the Bastion Host resource.
     */
    public val scaleUnits: Output<Int>?
        get() = javaResource.scaleUnits().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The sku of this Bastion Host.
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object BastionHostMapper : ResourceMapper<BastionHost> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.BastionHost::class == javaResource::class

    override fun map(javaResource: Resource): BastionHost = BastionHost(
        javaResource as
            com.pulumi.azurenative.network.BastionHost,
    )
}

/**
 * @see [BastionHost].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BastionHost].
 */
public suspend fun bastionHost(name: String, block: suspend BastionHostResourceBuilder.() -> Unit):
    BastionHost {
    val builder = BastionHostResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BastionHost].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bastionHost(name: String): BastionHost {
    val builder = BastionHostResourceBuilder()
    builder.name(name)
    return builder.build()
}
