@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.ConfigurationPolicyGroupArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.VpnServerConfigurationPolicyGroupMemberArgs
import com.pulumi.azurenative.network.kotlin.inputs.VpnServerConfigurationPolicyGroupMemberArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * VpnServerConfigurationPolicyGroup Resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2022-01-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### ConfigurationPolicyGroupPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configurationPolicyGroup = new AzureNative.Network.ConfigurationPolicyGroup("configurationPolicyGroup", new()
 *     {
 *         ConfigurationPolicyGroupName = "policyGroup1",
 *         IsDefault = true,
 *         PolicyMembers = new[]
 *         {
 *             new AzureNative.Network.Inputs.VpnServerConfigurationPolicyGroupMemberArgs
 *             {
 *                 AttributeType = AzureNative.Network.VpnPolicyMemberAttributeType.RadiusAzureGroupId,
 *                 AttributeValue = "6ad1bd08",
 *                 Name = "policy1",
 *             },
 *             new AzureNative.Network.Inputs.VpnServerConfigurationPolicyGroupMemberArgs
 *             {
 *                 AttributeType = AzureNative.Network.VpnPolicyMemberAttributeType.CertificateGroupId,
 *                 AttributeValue = "red.com",
 *                 Name = "policy2",
 *             },
 *         },
 *         Priority = 0,
 *         ResourceGroupName = "rg1",
 *         VpnServerConfigurationName = "vpnServerConfiguration1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewConfigurationPolicyGroup(ctx, "configurationPolicyGroup", &network.ConfigurationPolicyGroupArgs{
 * 			ConfigurationPolicyGroupName: pulumi.String("policyGroup1"),
 * 			IsDefault:                    pulumi.Bool(true),
 * 			PolicyMembers: network.VpnServerConfigurationPolicyGroupMemberArray{
 * 				&network.VpnServerConfigurationPolicyGroupMemberArgs{
 * 					AttributeType:  pulumi.String(network.VpnPolicyMemberAttributeTypeRadiusAzureGroupId),
 * 					AttributeValue: pulumi.String("6ad1bd08"),
 * 					Name:           pulumi.String("policy1"),
 * 				},
 * 				&network.VpnServerConfigurationPolicyGroupMemberArgs{
 * 					AttributeType:  pulumi.String(network.VpnPolicyMemberAttributeTypeCertificateGroupId),
 * 					AttributeValue: pulumi.String("red.com"),
 * 					Name:           pulumi.String("policy2"),
 * 				},
 * 			},
 * 			Priority:                   pulumi.Int(0),
 * 			ResourceGroupName:          pulumi.String("rg1"),
 * 			VpnServerConfigurationName: pulumi.String("vpnServerConfiguration1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ConfigurationPolicyGroup;
 * import com.pulumi.azurenative.network.ConfigurationPolicyGroupArgs;
 * import com.pulumi.azurenative.network.inputs.VpnServerConfigurationPolicyGroupMemberArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configurationPolicyGroup = new ConfigurationPolicyGroup("configurationPolicyGroup", ConfigurationPolicyGroupArgs.builder()
 *             .configurationPolicyGroupName("policyGroup1")
 *             .isDefault(true)
 *             .policyMembers(
 *                 VpnServerConfigurationPolicyGroupMemberArgs.builder()
 *                     .attributeType("RadiusAzureGroupId")
 *                     .attributeValue("6ad1bd08")
 *                     .name("policy1")
 *                     .build(),
 *                 VpnServerConfigurationPolicyGroupMemberArgs.builder()
 *                     .attributeType("CertificateGroupId")
 *                     .attributeValue("red.com")
 *                     .name("policy2")
 *                     .build())
 *             .priority(0)
 *             .resourceGroupName("rg1")
 *             .vpnServerConfigurationName("vpnServerConfiguration1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:ConfigurationPolicyGroup policyGroup1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnServerConfigurations/{vpnServerConfigurationName}/configurationPolicyGroups/{configurationPolicyGroupName}
 * ```
 * @property configurationPolicyGroupName The name of the ConfigurationPolicyGroup.
 * @property id Resource ID.
 * @property isDefault Shows if this is a Default VpnServerConfigurationPolicyGroup or not.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property policyMembers Multiple PolicyMembers for VpnServerConfigurationPolicyGroup.
 * @property priority Priority for VpnServerConfigurationPolicyGroup.
 * @property resourceGroupName The resource group name of the ConfigurationPolicyGroup.
 * @property vpnServerConfigurationName The name of the VpnServerConfiguration.
 */
public data class ConfigurationPolicyGroupArgs(
    public val configurationPolicyGroupName: Output<String>? = null,
    public val id: Output<String>? = null,
    public val isDefault: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val policyMembers: Output<List<VpnServerConfigurationPolicyGroupMemberArgs>>? = null,
    public val priority: Output<Int>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val vpnServerConfigurationName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.ConfigurationPolicyGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.network.ConfigurationPolicyGroupArgs =
        com.pulumi.azurenative.network.ConfigurationPolicyGroupArgs.builder()
            .configurationPolicyGroupName(configurationPolicyGroupName?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .isDefault(isDefault?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .policyMembers(
                policyMembers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .priority(priority?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .vpnServerConfigurationName(vpnServerConfigurationName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationPolicyGroupArgs].
 */
@PulumiTagMarker
public class ConfigurationPolicyGroupArgsBuilder internal constructor() {
    private var configurationPolicyGroupName: Output<String>? = null

    private var id: Output<String>? = null

    private var isDefault: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var policyMembers: Output<List<VpnServerConfigurationPolicyGroupMemberArgs>>? = null

    private var priority: Output<Int>? = null

    private var resourceGroupName: Output<String>? = null

    private var vpnServerConfigurationName: Output<String>? = null

    /**
     * @param value The name of the ConfigurationPolicyGroup.
     */
    @JvmName("ccwqcciupsjasyhy")
    public suspend fun configurationPolicyGroupName(`value`: Output<String>) {
        this.configurationPolicyGroupName = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("txshsiciblcteriq")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Shows if this is a Default VpnServerConfigurationPolicyGroup or not.
     */
    @JvmName("wesxtokxsmislxbe")
    public suspend fun isDefault(`value`: Output<Boolean>) {
        this.isDefault = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("fqevjqbhtubnkmbl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Multiple PolicyMembers for VpnServerConfigurationPolicyGroup.
     */
    @JvmName("rsrtofgoditvfccc")
    public suspend
    fun policyMembers(`value`: Output<List<VpnServerConfigurationPolicyGroupMemberArgs>>) {
        this.policyMembers = value
    }

    @JvmName("qfdjajqmaocxxtlv")
    public suspend fun policyMembers(
        vararg
        values: Output<VpnServerConfigurationPolicyGroupMemberArgs>,
    ) {
        this.policyMembers = Output.all(values.asList())
    }

    /**
     * @param values Multiple PolicyMembers for VpnServerConfigurationPolicyGroup.
     */
    @JvmName("maeytqouybuenhru")
    public suspend
    fun policyMembers(values: List<Output<VpnServerConfigurationPolicyGroupMemberArgs>>) {
        this.policyMembers = Output.all(values)
    }

    /**
     * @param value Priority for VpnServerConfigurationPolicyGroup.
     */
    @JvmName("dmjjwkcqluawtqpq")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The resource group name of the ConfigurationPolicyGroup.
     */
    @JvmName("hqsjrjohfitpxmwx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the VpnServerConfiguration.
     */
    @JvmName("ipquifuqiuyvyuul")
    public suspend fun vpnServerConfigurationName(`value`: Output<String>) {
        this.vpnServerConfigurationName = value
    }

    /**
     * @param value The name of the ConfigurationPolicyGroup.
     */
    @JvmName("jlduixcaxjfdrkir")
    public suspend fun configurationPolicyGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationPolicyGroupName = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("pysjeosiioxqnhlu")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Shows if this is a Default VpnServerConfigurationPolicyGroup or not.
     */
    @JvmName("lalulgvrvlpxlvmc")
    public suspend fun isDefault(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isDefault = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("xqkeqnqyetgagewk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Multiple PolicyMembers for VpnServerConfigurationPolicyGroup.
     */
    @JvmName("ppnxtwdvirfuwmve")
    public suspend fun policyMembers(`value`: List<VpnServerConfigurationPolicyGroupMemberArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyMembers = mapped
    }

    /**
     * @param argument Multiple PolicyMembers for VpnServerConfigurationPolicyGroup.
     */
    @JvmName("vntvqksrwldricmb")
    public suspend
    fun policyMembers(argument: List<suspend VpnServerConfigurationPolicyGroupMemberArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VpnServerConfigurationPolicyGroupMemberArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.policyMembers = mapped
    }

    /**
     * @param argument Multiple PolicyMembers for VpnServerConfigurationPolicyGroup.
     */
    @JvmName("kuvtbwrouknjvfph")
    public suspend fun policyMembers(
        vararg
        argument: suspend VpnServerConfigurationPolicyGroupMemberArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VpnServerConfigurationPolicyGroupMemberArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.policyMembers = mapped
    }

    /**
     * @param argument Multiple PolicyMembers for VpnServerConfigurationPolicyGroup.
     */
    @JvmName("kjpndafsovtjvwqa")
    public suspend
    fun policyMembers(argument: suspend VpnServerConfigurationPolicyGroupMemberArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VpnServerConfigurationPolicyGroupMemberArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.policyMembers = mapped
    }

    /**
     * @param values Multiple PolicyMembers for VpnServerConfigurationPolicyGroup.
     */
    @JvmName("rmmtscdnpmjgnsjc")
    public suspend fun policyMembers(vararg values: VpnServerConfigurationPolicyGroupMemberArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyMembers = mapped
    }

    /**
     * @param value Priority for VpnServerConfigurationPolicyGroup.
     */
    @JvmName("gvslaegdiningmkc")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The resource group name of the ConfigurationPolicyGroup.
     */
    @JvmName("twyrfyvijkafxydy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the VpnServerConfiguration.
     */
    @JvmName("vrqwevlehlihmotu")
    public suspend fun vpnServerConfigurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnServerConfigurationName = mapped
    }

    internal fun build(): ConfigurationPolicyGroupArgs = ConfigurationPolicyGroupArgs(
        configurationPolicyGroupName = configurationPolicyGroupName,
        id = id,
        isDefault = isDefault,
        name = name,
        policyMembers = policyMembers,
        priority = priority,
        resourceGroupName = resourceGroupName,
        vpnServerConfigurationName = vpnServerConfigurationName,
    )
}
