@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.DdosProtectionPlanArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A DDoS protection plan in a resource group.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2018-02-01, 2022-05-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### Create DDoS protection plan
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ddosProtectionPlan = new AzureNative.Network.DdosProtectionPlan("ddosProtectionPlan", new()
 *     {
 *         DdosProtectionPlanName = "test-plan",
 *         Location = "westus",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewDdosProtectionPlan(ctx, "ddosProtectionPlan", &network.DdosProtectionPlanArgs{
 * 			DdosProtectionPlanName: pulumi.String("test-plan"),
 * 			Location:               pulumi.String("westus"),
 * 			ResourceGroupName:      pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.DdosProtectionPlan;
 * import com.pulumi.azurenative.network.DdosProtectionPlanArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ddosProtectionPlan = new DdosProtectionPlan("ddosProtectionPlan", DdosProtectionPlanArgs.builder()
 *             .ddosProtectionPlanName("test-plan")
 *             .location("westus")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:DdosProtectionPlan test-plan /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ddosProtectionPlans/{ddosProtectionPlanName}
 * ```
 * @property ddosProtectionPlanName The name of the DDoS protection plan.
 * @property location Resource location.
 * @property resourceGroupName The name of the resource group.
 * @property tags Resource tags.
 */
public data class DdosProtectionPlanArgs(
    public val ddosProtectionPlanName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.DdosProtectionPlanArgs> {
    override fun toJava(): com.pulumi.azurenative.network.DdosProtectionPlanArgs =
        com.pulumi.azurenative.network.DdosProtectionPlanArgs.builder()
            .ddosProtectionPlanName(ddosProtectionPlanName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DdosProtectionPlanArgs].
 */
@PulumiTagMarker
public class DdosProtectionPlanArgsBuilder internal constructor() {
    private var ddosProtectionPlanName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the DDoS protection plan.
     */
    @JvmName("ojvaqwbdjbarcycv")
    public suspend fun ddosProtectionPlanName(`value`: Output<String>) {
        this.ddosProtectionPlanName = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("rhfkvpdxlsqjdjei")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("qivwqoxtcjqaquiy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("rarcqhkaenupyrln")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the DDoS protection plan.
     */
    @JvmName("gsdnqwokksjixkrn")
    public suspend fun ddosProtectionPlanName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ddosProtectionPlanName = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("ehqjikipppxxcmip")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("mxakkeoeeauclknj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("tgprapxnvanusnil")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("wdnpledkiuuqbvqm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DdosProtectionPlanArgs = DdosProtectionPlanArgs(
        ddosProtectionPlanName = ddosProtectionPlanName,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
