@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.DefaultAdminRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Network default admin rule.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * ## Example Usage
 * ### Create a default admin rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var defaultAdminRule = new AzureNative.Network.DefaultAdminRule("defaultAdminRule", new()
 *     {
 *         ConfigurationName = "myTestSecurityConfig",
 *         Flag = "AllowVnetInbound",
 *         Kind = "Default",
 *         NetworkManagerName = "testNetworkManager",
 *         ResourceGroupName = "rg1",
 *         RuleCollectionName = "testRuleCollection",
 *         RuleName = "SampleDefaultAdminRule",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewDefaultAdminRule(ctx, "defaultAdminRule", &network.DefaultAdminRuleArgs{
 * 			ConfigurationName:  pulumi.String("myTestSecurityConfig"),
 * 			Flag:               pulumi.String("AllowVnetInbound"),
 * 			Kind:               pulumi.String("Default"),
 * 			NetworkManagerName: pulumi.String("testNetworkManager"),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			RuleCollectionName: pulumi.String("testRuleCollection"),
 * 			RuleName:           pulumi.String("SampleDefaultAdminRule"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.DefaultAdminRule;
 * import com.pulumi.azurenative.network.DefaultAdminRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultAdminRule = new DefaultAdminRule("defaultAdminRule", DefaultAdminRuleArgs.builder()
 *             .configurationName("myTestSecurityConfig")
 *             .flag("AllowVnetInbound")
 *             .kind("Default")
 *             .networkManagerName("testNetworkManager")
 *             .resourceGroupName("rg1")
 *             .ruleCollectionName("testRuleCollection")
 *             .ruleName("SampleDefaultAdminRule")
 *             .build());
 *     }
 * }
 * ```
 * ### Create an admin rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var defaultAdminRule = new AzureNative.Network.DefaultAdminRule("defaultAdminRule", new()
 *     {
 *         ConfigurationName = "myTestSecurityConfig",
 *         NetworkManagerName = "testNetworkManager",
 *         ResourceGroupName = "rg1",
 *         RuleCollectionName = "testRuleCollection",
 *         RuleName = "SampleAdminRule",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewDefaultAdminRule(ctx, "defaultAdminRule", &network.DefaultAdminRuleArgs{
 * 			ConfigurationName:  pulumi.String("myTestSecurityConfig"),
 * 			NetworkManagerName: pulumi.String("testNetworkManager"),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			RuleCollectionName: pulumi.String("testRuleCollection"),
 * 			RuleName:           pulumi.String("SampleAdminRule"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.DefaultAdminRule;
 * import com.pulumi.azurenative.network.DefaultAdminRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultAdminRule = new DefaultAdminRule("defaultAdminRule", DefaultAdminRuleArgs.builder()
 *             .configurationName("myTestSecurityConfig")
 *             .networkManagerName("testNetworkManager")
 *             .resourceGroupName("rg1")
 *             .ruleCollectionName("testRuleCollection")
 *             .ruleName("SampleAdminRule")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:DefaultAdminRule SampleAdminRule /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/securityAdminConfigurations/{configurationName}/ruleCollections/{ruleCollectionName}/rules/{ruleName}
 * ```
 * @property configurationName The name of the network manager Security Configuration.
 * @property flag Default rule flag.
 * @property kind Whether the rule is custom or default.
 * Expected value is 'Default'.
 * @property networkManagerName The name of the network manager.
 * @property resourceGroupName The name of the resource group.
 * @property ruleCollectionName The name of the network manager security Configuration rule collection.
 * @property ruleName The name of the rule.
 */
public data class DefaultAdminRuleArgs(
    public val configurationName: Output<String>? = null,
    public val flag: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val networkManagerName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val ruleCollectionName: Output<String>? = null,
    public val ruleName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.DefaultAdminRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.network.DefaultAdminRuleArgs =
        com.pulumi.azurenative.network.DefaultAdminRuleArgs.builder()
            .configurationName(configurationName?.applyValue({ args0 -> args0 }))
            .flag(flag?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .networkManagerName(networkManagerName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .ruleCollectionName(ruleCollectionName?.applyValue({ args0 -> args0 }))
            .ruleName(ruleName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefaultAdminRuleArgs].
 */
@PulumiTagMarker
public class DefaultAdminRuleArgsBuilder internal constructor() {
    private var configurationName: Output<String>? = null

    private var flag: Output<String>? = null

    private var kind: Output<String>? = null

    private var networkManagerName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var ruleCollectionName: Output<String>? = null

    private var ruleName: Output<String>? = null

    /**
     * @param value The name of the network manager Security Configuration.
     */
    @JvmName("noqdcbhyktiqfquf")
    public suspend fun configurationName(`value`: Output<String>) {
        this.configurationName = value
    }

    /**
     * @param value Default rule flag.
     */
    @JvmName("lgqgiowptknnpaqn")
    public suspend fun flag(`value`: Output<String>) {
        this.flag = value
    }

    /**
     * @param value Whether the rule is custom or default.
     * Expected value is 'Default'.
     */
    @JvmName("lomsyfeoldpvmbrq")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The name of the network manager.
     */
    @JvmName("shkpkyjukatulubg")
    public suspend fun networkManagerName(`value`: Output<String>) {
        this.networkManagerName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("hkddrjmfctrqxedo")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the network manager security Configuration rule collection.
     */
    @JvmName("axfufalvhybuygkh")
    public suspend fun ruleCollectionName(`value`: Output<String>) {
        this.ruleCollectionName = value
    }

    /**
     * @param value The name of the rule.
     */
    @JvmName("aiqbwtkvdgobttrs")
    public suspend fun ruleName(`value`: Output<String>) {
        this.ruleName = value
    }

    /**
     * @param value The name of the network manager Security Configuration.
     */
    @JvmName("yuervuqqcusqmmls")
    public suspend fun configurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationName = mapped
    }

    /**
     * @param value Default rule flag.
     */
    @JvmName("bjacykuyyckucarr")
    public suspend fun flag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flag = mapped
    }

    /**
     * @param value Whether the rule is custom or default.
     * Expected value is 'Default'.
     */
    @JvmName("cocpvygtivummidb")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The name of the network manager.
     */
    @JvmName("axenfdiubvovfnfr")
    public suspend fun networkManagerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkManagerName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("kesjstasxgmranqm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the network manager security Configuration rule collection.
     */
    @JvmName("crcvfoqipwqrbeld")
    public suspend fun ruleCollectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleCollectionName = mapped
    }

    /**
     * @param value The name of the rule.
     */
    @JvmName("otjqyidtclaevprg")
    public suspend fun ruleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleName = mapped
    }

    internal fun build(): DefaultAdminRuleArgs = DefaultAdminRuleArgs(
        configurationName = configurationName,
        flag = flag,
        kind = kind,
        networkManagerName = networkManagerName,
        resourceGroupName = resourceGroupName,
        ruleCollectionName = ruleCollectionName,
        ruleName = ruleName,
    )
}
