@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.DnsForwardingRulesetArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes a DNS forwarding ruleset.
 * Azure REST API version: 2022-07-01. Prior API version in Azure Native 1.x: 2020-04-01-preview.
 * Other available API versions: 2020-04-01-preview.
 * ## Example Usage
 * ### Upsert DNS forwarding ruleset
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dnsForwardingRuleset = new AzureNative.Network.DnsForwardingRuleset("dnsForwardingRuleset", new()
 *     {
 *         DnsForwardingRulesetName = "samplednsForwardingRuleset",
 *         DnsResolverOutboundEndpoints = new[]
 *         {
 *             new AzureNative.Network.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/abdd4249-9f34-4cc6-8e42-c2e32110603e/resourceGroups/sampleResourceGroup/providers/Microsoft.Network/dnsResolvers/sampleDnsResolver/outboundEndpoints/sampleOutboundEndpoint0",
 *             },
 *             new AzureNative.Network.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/abdd4249-9f34-4cc6-8e42-c2e32110603e/resourceGroups/sampleResourceGroup/providers/Microsoft.Network/dnsResolvers/sampleDnsResolver/outboundEndpoints/sampleOutboundEndpoint1",
 *             },
 *         },
 *         Location = "westus2",
 *         ResourceGroupName = "sampleResourceGroup",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewDnsForwardingRuleset(ctx, "dnsForwardingRuleset", &network.DnsForwardingRulesetArgs{
 * 			DnsForwardingRulesetName: pulumi.String("samplednsForwardingRuleset"),
 * 			DnsResolverOutboundEndpoints: network.SubResourceArray{
 * 				&network.SubResourceArgs{
 * 					Id: pulumi.String("/subscriptions/abdd4249-9f34-4cc6-8e42-c2e32110603e/resourceGroups/sampleResourceGroup/providers/Microsoft.Network/dnsResolvers/sampleDnsResolver/outboundEndpoints/sampleOutboundEndpoint0"),
 * 				},
 * 				&network.SubResourceArgs{
 * 					Id: pulumi.String("/subscriptions/abdd4249-9f34-4cc6-8e42-c2e32110603e/resourceGroups/sampleResourceGroup/providers/Microsoft.Network/dnsResolvers/sampleDnsResolver/outboundEndpoints/sampleOutboundEndpoint1"),
 * 				},
 * 			},
 * 			Location:          pulumi.String("westus2"),
 * 			ResourceGroupName: pulumi.String("sampleResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.DnsForwardingRuleset;
 * import com.pulumi.azurenative.network.DnsForwardingRulesetArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dnsForwardingRuleset = new DnsForwardingRuleset("dnsForwardingRuleset", DnsForwardingRulesetArgs.builder()
 *             .dnsForwardingRulesetName("samplednsForwardingRuleset")
 *             .dnsResolverOutboundEndpoints(
 *                 SubResourceArgs.builder()
 *                     .id("/subscriptions/abdd4249-9f34-4cc6-8e42-c2e32110603e/resourceGroups/sampleResourceGroup/providers/Microsoft.Network/dnsResolvers/sampleDnsResolver/outboundEndpoints/sampleOutboundEndpoint0")
 *                     .build(),
 *                 SubResourceArgs.builder()
 *                     .id("/subscriptions/abdd4249-9f34-4cc6-8e42-c2e32110603e/resourceGroups/sampleResourceGroup/providers/Microsoft.Network/dnsResolvers/sampleDnsResolver/outboundEndpoints/sampleOutboundEndpoint1")
 *                     .build())
 *             .location("westus2")
 *             .resourceGroupName("sampleResourceGroup")
 *             .tags(Map.of("key1", "value1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:DnsForwardingRuleset sampleDnsForwardingRuleset /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsForwardingRulesets/{dnsForwardingRulesetName}
 * ```
 * @property dnsForwardingRulesetName The name of the DNS forwarding ruleset.
 * @property dnsResolverOutboundEndpoints The reference to the DNS resolver outbound endpoints that are used to route DNS queries matching the forwarding rules in the ruleset to the target DNS servers.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class DnsForwardingRulesetArgs(
    public val dnsForwardingRulesetName: Output<String>? = null,
    public val dnsResolverOutboundEndpoints: Output<List<SubResourceArgs>>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.DnsForwardingRulesetArgs> {
    override fun toJava(): com.pulumi.azurenative.network.DnsForwardingRulesetArgs =
        com.pulumi.azurenative.network.DnsForwardingRulesetArgs.builder()
            .dnsForwardingRulesetName(dnsForwardingRulesetName?.applyValue({ args0 -> args0 }))
            .dnsResolverOutboundEndpoints(
                dnsResolverOutboundEndpoints?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DnsForwardingRulesetArgs].
 */
@PulumiTagMarker
public class DnsForwardingRulesetArgsBuilder internal constructor() {
    private var dnsForwardingRulesetName: Output<String>? = null

    private var dnsResolverOutboundEndpoints: Output<List<SubResourceArgs>>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the DNS forwarding ruleset.
     */
    @JvmName("bdjdxkqrrwcqlvtu")
    public suspend fun dnsForwardingRulesetName(`value`: Output<String>) {
        this.dnsForwardingRulesetName = value
    }

    /**
     * @param value The reference to the DNS resolver outbound endpoints that are used to route DNS queries matching the forwarding rules in the ruleset to the target DNS servers.
     */
    @JvmName("xspojvcriwwwajpl")
    public suspend fun dnsResolverOutboundEndpoints(`value`: Output<List<SubResourceArgs>>) {
        this.dnsResolverOutboundEndpoints = value
    }

    @JvmName("dpofggkswookrrvf")
    public suspend fun dnsResolverOutboundEndpoints(vararg values: Output<SubResourceArgs>) {
        this.dnsResolverOutboundEndpoints = Output.all(values.asList())
    }

    /**
     * @param values The reference to the DNS resolver outbound endpoints that are used to route DNS queries matching the forwarding rules in the ruleset to the target DNS servers.
     */
    @JvmName("akqyrjhlmjpsgljj")
    public suspend fun dnsResolverOutboundEndpoints(values: List<Output<SubResourceArgs>>) {
        this.dnsResolverOutboundEndpoints = Output.all(values)
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("njeuvohliecuxmwx")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gyggynkpelmfpsux")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("dsljaecbrkesjcav")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the DNS forwarding ruleset.
     */
    @JvmName("bywecaoaaffouttp")
    public suspend fun dnsForwardingRulesetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsForwardingRulesetName = mapped
    }

    /**
     * @param value The reference to the DNS resolver outbound endpoints that are used to route DNS queries matching the forwarding rules in the ruleset to the target DNS servers.
     */
    @JvmName("nljgvpvyhtjjoinq")
    public suspend fun dnsResolverOutboundEndpoints(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsResolverOutboundEndpoints = mapped
    }

    /**
     * @param argument The reference to the DNS resolver outbound endpoints that are used to route DNS queries matching the forwarding rules in the ruleset to the target DNS servers.
     */
    @JvmName("pkkuigctwmlvmqku")
    public suspend
    fun dnsResolverOutboundEndpoints(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.dnsResolverOutboundEndpoints = mapped
    }

    /**
     * @param argument The reference to the DNS resolver outbound endpoints that are used to route DNS queries matching the forwarding rules in the ruleset to the target DNS servers.
     */
    @JvmName("oklobcvaoxuvdwkm")
    public suspend fun dnsResolverOutboundEndpoints(
        vararg
        argument: suspend SubResourceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.dnsResolverOutboundEndpoints = mapped
    }

    /**
     * @param argument The reference to the DNS resolver outbound endpoints that are used to route DNS queries matching the forwarding rules in the ruleset to the target DNS servers.
     */
    @JvmName("fhsliaavdskqthhl")
    public suspend
    fun dnsResolverOutboundEndpoints(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dnsResolverOutboundEndpoints = mapped
    }

    /**
     * @param values The reference to the DNS resolver outbound endpoints that are used to route DNS queries matching the forwarding rules in the ruleset to the target DNS servers.
     */
    @JvmName("yqbcbsytnceoeisk")
    public suspend fun dnsResolverOutboundEndpoints(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsResolverOutboundEndpoints = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ddjtkgofvgkyqshh")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ydiaxayygiejjwdp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("tihmuwpgmvpvelmg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("aenuywsaiqrkrqff")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DnsForwardingRulesetArgs = DnsForwardingRulesetArgs(
        dnsForwardingRulesetName = dnsForwardingRulesetName,
        dnsResolverOutboundEndpoints = dnsResolverOutboundEndpoints,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
