@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [DnsResolver].
 */
@PulumiTagMarker
public class DnsResolverResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DnsResolverArgs = DnsResolverArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DnsResolverArgsBuilder.() -> Unit) {
        val builder = DnsResolverArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DnsResolver {
        val builtJavaResource = com.pulumi.azurenative.network.DnsResolver(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DnsResolver(builtJavaResource)
    }
}

/**
 * Describes a DNS resolver.
 * Azure REST API version: 2022-07-01. Prior API version in Azure Native 1.x: 2020-04-01-preview.
 * ## Example Usage
 * ### Upsert DNS resolver
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dnsResolver = new AzureNative.Network.DnsResolver("dnsResolver", new()
 *     {
 *         DnsResolverName = "sampleDnsResolver",
 *         Location = "westus2",
 *         ResourceGroupName = "sampleResourceGroup",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         VirtualNetwork = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/cbb1387e-4b03-44f2-ad41-58d4677b9873/resourceGroups/virtualNetworkResourceGroup/providers/Microsoft.Network/virtualNetworks/sampleVirtualNetwork",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewDnsResolver(ctx, "dnsResolver", &network.DnsResolverArgs{
 * 			DnsResolverName:   pulumi.String("sampleDnsResolver"),
 * 			Location:          pulumi.String("westus2"),
 * 			ResourceGroupName: pulumi.String("sampleResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			VirtualNetwork: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/cbb1387e-4b03-44f2-ad41-58d4677b9873/resourceGroups/virtualNetworkResourceGroup/providers/Microsoft.Network/virtualNetworks/sampleVirtualNetwork"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.DnsResolver;
 * import com.pulumi.azurenative.network.DnsResolverArgs;
 * import com.pulumi.azurenative.network.inputs.SubResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dnsResolver = new DnsResolver("dnsResolver", DnsResolverArgs.builder()
 *             .dnsResolverName("sampleDnsResolver")
 *             .location("westus2")
 *             .resourceGroupName("sampleResourceGroup")
 *             .tags(Map.of("key1", "value1"))
 *             .virtualNetwork(SubResourceArgs.builder()
 *                 .id("/subscriptions/cbb1387e-4b03-44f2-ad41-58d4677b9873/resourceGroups/virtualNetworkResourceGroup/providers/Microsoft.Network/virtualNetworks/sampleVirtualNetwork")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:DnsResolver sampleDnsResolver /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolvers/{dnsResolverName}
 * ```
 */
public class DnsResolver internal constructor(
    override val javaResource: com.pulumi.azurenative.network.DnsResolver,
) : KotlinCustomResource(javaResource, DnsResolverMapper) {
    /**
     * The current status of the DNS resolver. This is a read-only property and any attempt to set this value will be ignored.
     */
    public val dnsResolverState: Output<String>
        get() = javaResource.dnsResolverState().applyValue({ args0 -> args0 })

    /**
     * ETag of the DNS resolver.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The current provisioning state of the DNS resolver. This is a read-only property and any attempt to set this value will be ignored.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The resourceGuid property of the DNS resolver resource.
     */
    public val resourceGuid: Output<String>
        get() = javaResource.resourceGuid().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The reference to the virtual network. This cannot be changed after creation.
     */
    public val virtualNetwork: Output<SubResourceResponse>
        get() = javaResource.virtualNetwork().applyValue({ args0 ->
            args0.let({ args0 ->
                subResourceResponseToKotlin(args0)
            })
        })
}

public object DnsResolverMapper : ResourceMapper<DnsResolver> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.DnsResolver::class == javaResource::class

    override fun map(javaResource: Resource): DnsResolver = DnsResolver(
        javaResource as
            com.pulumi.azurenative.network.DnsResolver,
    )
}

/**
 * @see [DnsResolver].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DnsResolver].
 */
public suspend fun dnsResolver(name: String, block: suspend DnsResolverResourceBuilder.() -> Unit):
    DnsResolver {
    val builder = DnsResolverResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DnsResolver].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dnsResolver(name: String): DnsResolver {
    val builder = DnsResolverResourceBuilder()
    builder.name(name)
    return builder.build()
}
